/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.framebuffer;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryStack;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfoCache;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.nio.IntBuffer;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class GlFramebuffer
extends GlResource {
    private final Int2IntMap attachments = new Int2IntArrayMap();
    private final int maxDrawBuffers = GL11.glGetInteger((int)34852);
    private final int maxColorAttachments = GL11.glGetInteger((int)36063);
    private boolean hasDepthAttachment = false;

    public GlFramebuffer() {
        super(RenderSystem.createFramebuffer());
    }

    public void addDepthAttachment(int texture) {
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(texture).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        int fb = this.getGlId();
        if (depthBufferFormat.isCombinedStencil()) {
            RenderSystem.framebufferTexture2D(fb, 36160, 33306, 3553, texture, 0);
        } else {
            RenderSystem.framebufferTexture2D(fb, 36160, 36096, 3553, texture, 0);
        }
        this.hasDepthAttachment = true;
    }

    public void addColorAttachment(int index, int texture) {
        int fb = this.getGlId();
        RenderSystem.framebufferTexture2D(fb, 36160, 36064 + index, 3553, texture, 0);
        this.attachments.put(index, texture);
    }

    public void noDrawBuffers() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(1);
            buffer.put(0);
            RenderSystem.drawBuffers(this.getGlId(), buffer);
        }
    }

    public void drawBuffers(int[] buffers) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer glBuffers = stack.mallocInt(buffers.length);
            int index = 0;
            if (buffers.length > this.maxDrawBuffers) {
                throw new IllegalArgumentException("Cannot write to more than " + this.maxDrawBuffers + " draw buffers on this GPU");
            }
            for (int buffer : buffers) {
                if (buffer >= this.maxColorAttachments) {
                    throw new IllegalArgumentException("Only " + this.maxColorAttachments + " color attachments are supported on this GPU, but an attempt was made to write to a color attachment with index " + buffer);
                }
                glBuffers.put(index++, 36064 + buffer);
            }
            RenderSystem.drawBuffers(this.getGlId(), glBuffers);
        }
    }

    public void readBuffer(int buffer) {
        RenderSystem.readBuffer(this.getGlId(), 36064 + buffer);
    }

    public int getColorAttachment(int index) {
        return this.attachments.get(index);
    }

    public boolean hasDepthAttachment() {
        return this.hasDepthAttachment;
    }

    public void bind() {
        OpenGlHelper.func_153171_g((int)36160, (int)this.getGlId());
    }

    public void bindAsReadBuffer() {
        OpenGlHelper.func_153171_g((int)36008, (int)this.getGlId());
    }

    public void bindAsDrawBuffer() {
        OpenGlHelper.func_153171_g((int)36009, (int)this.getGlId());
    }

    @Override
    protected void destroyInternal() {
        OpenGlHelper.func_153184_g((int)this.getGlId());
    }

    public boolean isComplete() {
        this.bind();
        return OpenGlHelper.func_153167_i((int)36160) == 36053;
    }

    public int getId() {
        return this.getGlId();
    }
}

