/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.gtnewhorizons.angelica.rendering.RenderingState;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shadow.ShadowMatrices;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class MatrixUniforms {
    private MatrixUniforms() {
    }

    public static void addMatrixUniforms(UniformHolder uniforms, PackDirectives directives) {
        MatrixUniforms.addMatrix(uniforms, "ModelView", RenderingState.INSTANCE::getModelViewMatrix);
        MatrixUniforms.addMatrix(uniforms, "Projection", RenderingState.INSTANCE::getProjectionMatrix);
        MatrixUniforms.addShadowMatrix(uniforms, "ModelView", () -> ShadowRenderer.createShadowModelView(directives.getSunPathRotation(), directives.getShadowDirectives().getIntervalSize()).peek().getModel());
        MatrixUniforms.addShadowMatrix(uniforms, "Projection", () -> ShadowMatrices.createOrthoMatrix(directives.getShadowDirectives().getDistance()));
    }

    private static void addMatrix(UniformHolder uniforms, String name, Supplier<Matrix4f> supplier) {
        uniforms.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + name, supplier).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + name + "Inverse", new Inverted(supplier)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbufferPrevious" + name, new Previous(supplier));
    }

    private static void addShadowMatrix(UniformHolder uniforms, String name, Supplier<Matrix4f> supplier) {
        uniforms.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name, supplier).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name + "Inverse", new Inverted(supplier));
    }

    private static class Inverted
    implements Supplier<Matrix4f> {
        private final Supplier<Matrix4f> parent;

        Inverted(Supplier<Matrix4f> parent) {
            this.parent = parent;
        }

        @Override
        public Matrix4f get() {
            Matrix4f copy = new Matrix4f((Matrix4fc)this.parent.get());
            copy.invert();
            return copy;
        }
    }

    private static class Previous
    implements Supplier<Matrix4f> {
        private final Supplier<Matrix4f> parent;
        private Matrix4f previous;

        Previous(Supplier<Matrix4f> parent) {
            this.parent = parent;
            this.previous = new Matrix4f();
        }

        @Override
        public Matrix4f get() {
            Matrix4f copy = new Matrix4f((Matrix4fc)this.parent.get());
            Matrix4f prev = new Matrix4f((Matrix4fc)this.previous);
            this.previous = copy;
            return prev;
        }
    }
}

