/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessBolt;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WRCoreSPH
implements PacketCustom.IServerPacketHandler {
    public static List<PacketCustom.IServerPacketHandler> delegates = new LinkedList<PacketCustom.IServerPacketHandler>();

    public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer handler) {
        this.handlePacket((WorldServer)sender.field_70170_p, sender, packet);
        for (PacketCustom.IServerPacketHandler delegate : delegates) {
            delegate.handlePacket(packet, sender, handler);
        }
    }

    private void handlePacket(WorldServer world, EntityPlayerMP player, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                this.setTileFreq((EntityPlayer)player, (World)world, packet.readCoord(), packet.readShort());
                break;
            }
            case 2: {
                this.setItemFreq(player, packet.readShort(), packet.readShort());
                break;
            }
            case 4: {
                this.handleFreqInfo(packet);
                break;
            }
            case 5: {
                this.decrementSlot(player, packet.readShort());
                break;
            }
            case 9: {
                RedstoneEther.get(false).setFreqOwner(packet.readShort(), packet.readString());
            }
        }
    }

    private void decrementSlot(EntityPlayerMP player, int slot) {
        try {
            ItemStack item = player.field_71071_by.field_70462_a[slot];
            --item.field_77994_a;
            if (item.field_77994_a == 0) {
                player.field_71071_by.field_70462_a[slot] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void setItemFreq(EntityPlayerMP sender, int slot, int freq) {
        ItemStack stack;
        if (RedstoneEther.get(false).canBroadcastOnFrequency((EntityPlayer)sender, freq) && (stack = sender.field_71071_by.field_70462_a[slot]) != null && stack.func_77973_b() instanceof ItemWirelessFreq) {
            ((ItemWirelessFreq)stack.func_77973_b()).setFreq((EntityPlayer)sender, slot, stack, freq);
        }
    }

    private void setTileFreq(EntityPlayer sender, World world, BlockCoord pos, int freq) {
        TileEntity tile;
        if (RedstoneEther.get(false).canBroadcastOnFrequency(sender, freq) && (tile = RedstoneEther.getTile(world, pos)) instanceof ITileWireless) {
            RedstoneEther.get(false).setFreq((ITileWireless)tile, freq);
        }
    }

    private void handleFreqInfo(PacketCustom packet) {
        int freq = packet.readUShort();
        String name = packet.readString();
        short colourid = packet.readUByte();
        RedstoneEther.get(false).setFreqName(freq, name);
        RedstoneEther.get(false).setFreqColour(freq, colourid);
        WRCoreSPH.sendSetFreqInfoTo(null, freq, name, colourid);
    }

    public static void sendSetFrequencyRangeTo(EntityPlayer player, int startfreq, int endfreq, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 3);
        packet.writeShort((int)((short)startfreq));
        packet.writeShort((int)((short)endfreq));
        packet.writeBoolean(jam);
        packet.sendToPlayer(player);
    }

    public static void sendPublicFrequencyTo(EntityPlayer player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(1);
        packet.sendToPlayer(player);
    }

    public static void sendSharedFrequencyTo(EntityPlayer player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(2);
        packet.sendToPlayer(player);
    }

    public static void sendSetFreqInfoTo(EntityPlayer player, int freq, String name, int colourid) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 4);
        packet.writeShort(freq);
        packet.writeByte(colourid);
        packet.writeString(name);
        packet.sendToPlayer(player);
    }

    public static void sendJamPlayerPacketTo(EntityPlayer player, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 7);
        packet.writeBoolean(jam);
        packet.sendToPlayer(player);
    }

    public static void sendWirelessBolt(WirelessBolt bolt) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 8);
        packet.writeFloat((float)bolt.start.x);
        packet.writeFloat((float)bolt.start.y);
        packet.writeFloat((float)bolt.start.z);
        packet.writeFloat((float)bolt.end.x);
        packet.writeFloat((float)bolt.end.y);
        packet.writeFloat((float)bolt.end.z);
        packet.writeLong(bolt.seed);
        packet.sendToChunk(bolt.world, (int)bolt.start.x >> 4, (int)bolt.start.z >> 4);
    }

    public static void sendSetSlot(int slot, ItemStack stack) {
    }

    public static void sendFreqInfoTo(EntityPlayer player, ArrayList<Integer> freqsWithInfo) {
        if (freqsWithInfo.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 1);
        packet.writeShort(freqsWithInfo.size());
        for (int freq : freqsWithInfo) {
            packet.writeShort(freq);
            packet.writeByte(RedstoneEther.get(false).getFreqColourId(freq));
            packet.writeString(RedstoneEther.get(false).getFreqName(freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendFreqOwnerTo(EntityPlayer player, ArrayList<Integer> freqsWithOwners) {
        if (freqsWithOwners.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 10);
        packet.writeShort(freqsWithOwners.size());
        for (int freq : freqsWithOwners) {
            packet.writeShort(freq);
            packet.writeString(RedstoneEther.get(false).getFreqOwner(freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendSetFreqOwner(int freq, String username) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 9);
        packet.writeShort(freq);
        packet.writeString(username);
        packet.sendToClients();
    }
}

