/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.items.ItemMagCard;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityMagReader
extends TileEntityMachineBase
implements Environment {
    public String data;
    public String eventName = "magData";
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityMagReader.getComponentName()).withConnector(32.0).create();

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_magreader";
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message arg0) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        this.eventName = nbt.func_74764_b("eventName") && !nbt.func_74779_i("eventName").isEmpty() ? nbt.func_74779_i("eventName") : "magData";
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        nbt.func_74778_a("eventName", this.eventName);
    }

    public boolean doRead(ItemStack itemStack, EntityPlayer em, int side) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemMagCard && this.field_145847_g == 0 && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "opensecurity:card_swipe", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemMagCard && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("data")) {
            this.data = itemStack.field_77990_d.func_74779_i("data");
            String uuid = itemStack.field_77990_d.func_74779_i("uuid");
            boolean locked = itemStack.field_77990_d.func_74767_n("locked");
            if (this.node.changeBuffer(-5.0) == 0.0) {
                String localUUID = !OpenSecurity.ignoreUUIDs ? uuid : "-1";
                String user = OpenSecurity.cfg.magCardDisplayName ? em.getDisplayName() : "player";
                this.node.sendToReachable("computer.signal", new Object[]{this.eventName, user, this.data, localUUID, locked, side});
            }
            return true;
        }
        return false;
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback(doc="function(String:name):boolean; Sets the name of the event that gets sent when a card is swipped", direct=true)
    public Object[] setEventName(Context context, Arguments args) throws Exception {
        this.eventName = args.checkString(0);
        return new Object[]{true};
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }
}

