/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.api.example.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import tuhljin.automagy.api.inventarium.IInventariumContentsProvider;

public class ProviderForStorageDrawers
implements IInventariumContentsProvider {
    public static final int PRIORITY = 120;
    private static ItemStack dummyItemOnePerStack = new ItemStack(Items.field_151041_m);

    @Override
    public boolean canHandleTile(TileEntity te) {
        return te instanceof IDrawerGroup;
    }

    @Override
    public int getSlotCount(TileEntity te, int setID) {
        int slots = 0;
        IDrawerGroup group = (IDrawerGroup)te;
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!group.isDrawerEnabled(i) || (drawer = group.getDrawer(i)) == null) continue;
            if (drawer.isEmpty()) {
                slots += drawer.getMaxCapacity(dummyItemOnePerStack);
                continue;
            }
            if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() != 1) continue;
            slots += drawer.getMaxCapacity() / drawer.getStoredItemStackSize();
        }
        return slots;
    }

    @Override
    public ItemStack[] getContents(TileEntity te, int setID) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        IDrawerGroup group = (IDrawerGroup)te;
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            ItemStack stack;
            IDrawer drawer;
            if (!group.isDrawerEnabled(i) || (drawer = group.getDrawer(i)) == null || (stack = drawer.getStoredItemCopy()) == null) continue;
            list.add(stack);
        }
        return list.toArray(new ItemStack[list.size()]);
    }
}

