/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.tiles.TileJarBrain;
import tuhljin.automagy.blocks.BlockAmnesiac;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityXPStone;

public class TileEntityAmnesiacStone
extends ModTileEntity {
    public static int MAX_ITEMS_PER_DRAIN = 5;
    public Boolean isSharingStorage = null;
    protected int comparatorStrength = 0;
    private int ticks = 0;
    private int totalXP = 0;
    private int totalXPMax = 0;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isSharingStorage == null) {
                this.isSharingStorage = false;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir == ForgeDirection.UP || !(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof TileEntityXPStone)) continue;
                    this.isSharingStorage = true;
                    break;
                }
            }
            ++this.ticks;
            if (this.ticks % 2 == 0 && !this.calcComparatorStrength(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e))) {
                AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.5), (double)(this.field_145849_e + 1));
                for (EntityPlayer player : this.getPlayersInArea(bb)) {
                    if (player.field_70128_L) continue;
                    ModBlocks.amnesiacBlock.drainExperience(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, player, BlockAmnesiac.DRAIN_WALK, true);
                }
                List<PairedItemToDrain> toDrain = this.getXPDrainableItemsInArea(bb);
                if (toDrain != null) {
                    int itemsDrained = 0;
                    for (PairedItemToDrain entry : toDrain) {
                        EntityItem entity = entry.entity;
                        ItemStack stack = entity.func_92059_d();
                        int consume = Math.min(stack.field_77994_a, MAX_ITEMS_PER_DRAIN - itemsDrained);
                        itemsDrained += consume;
                        int left = stack.field_77994_a - consume;
                        Object replacement = null;
                        if (entry.result.replacementUseContainer) {
                            ItemStack container = stack.func_77973_b().getContainerItem(stack);
                            if (container != null) {
                                replacement = container.func_77984_f() && container.func_77960_j() > container.func_77958_k() ? null : container.func_77946_l();
                            }
                        } else if (entry.result.replacement != null) {
                            replacement = entry.result.replacement.func_77946_l();
                        }
                        if (replacement != null) {
                            replacement.field_77994_a = consume;
                            EntityItem remainder = new EntityItem(this.field_145850_b, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, replacement);
                            this.field_145850_b.func_72838_d((Entity)remainder);
                        }
                        if (left < 1) {
                            entity.func_70106_y();
                        } else {
                            stack = stack.func_77946_l();
                            stack.field_77994_a = left;
                            entity.func_92058_a(stack);
                        }
                        int xpEach = entry.result.xp;
                        TjUtil.spawnSuppressedExperienceIntoWorld(xpEach * consume, BlockAmnesiac.XP_ORB_SUPPRESS_FOLLOW_TIME, this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5);
                        if (itemsDrained < MAX_ITEMS_PER_DRAIN) continue;
                        break;
                    }
                    if (itemsDrained > 0) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 2.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
                    }
                }
            }
        }
    }

    public List<EntityPlayer> getPlayersInArea(AxisAlignedBB bb) {
        return this.field_145850_b.func_72872_a(EntityPlayer.class, bb);
    }

    public List<PairedItemToDrain> getXPDrainableItemsInArea(AxisAlignedBB bb) {
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, bb);
        if (entities.size() == 0) {
            return null;
        }
        ArrayList<PairedItemToDrain> list = new ArrayList<PairedItemToDrain>();
        for (EntityItem item : entities) {
            ItemStack stack;
            if (item.field_70128_L || (stack = item.func_92059_d()) == null || stack.field_77994_a <= 0) continue;
            HashableItemWithoutSize hi = new HashableItemWithoutSize(stack);
            if (AutomagyConfig.amnesiacDrainItems.containsKey(hi)) {
                list.add(new PairedItemToDrain(item, AutomagyConfig.amnesiacDrainItems.get(hi)));
                continue;
            }
            if (!AutomagyConfig.amnesiacDrainItems.containsKey(hi = HashableItemWithoutSize.getWithWildcardDamage(hi))) continue;
            list.add(new PairedItemToDrain(item, AutomagyConfig.amnesiacDrainItems.get(hi)));
        }
        return list;
    }

    public boolean calcComparatorStrength(TileEntity te) {
        boolean hasBrain = false;
        int xp = 0;
        int max = 0;
        if (te instanceof TileJarBrain) {
            hasBrain = true;
            TileJarBrain brain = (TileJarBrain)te;
            xp = brain.xp;
            max = brain.xpMax;
            if (Boolean.TRUE.equals(this.isSharingStorage)) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity te2;
                    if (dir == ForgeDirection.UP || !((te2 = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) instanceof TileEntityXPStone)) continue;
                    TileEntityXPStone stone = (TileEntityXPStone)te2;
                    xp += stone.getXP();
                    max += stone.getMaxXP();
                }
            }
        }
        if (this.totalXP != xp || this.totalXPMax != max) {
            int strength;
            this.totalXP = xp;
            this.totalXPMax = max;
            int n = strength = hasBrain ? RedstoneCalc.getRedstoneSignalStrengthFromValues(this.totalXP, max) : 0;
            if (this.comparatorStrength != strength) {
                this.comparatorStrength = strength;
                this.markDirty(false);
            }
        }
        return hasBrain;
    }

    public void doXPTransfer(TileEntityXPStone stone, int xpStone) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (te instanceof TileJarBrain) {
            TileJarBrain brain = (TileJarBrain)te;
            int xpBrain = brain.xp;
            if (xpBrain != xpStone) {
                int average = (xpBrain + xpStone) / 2;
                if (xpBrain < average) {
                    int max = Math.min(brain.xpMax - xpBrain, average - xpBrain);
                    int drained = stone.drainXP(max);
                    TileEntityAmnesiacStone.setBrainInJarXP(brain, xpBrain + drained);
                } else {
                    int max = Math.min(xpBrain, average - xpStone);
                    if (max == 0) {
                        max = 1;
                    }
                    int added = stone.addXP(max);
                    TileEntityAmnesiacStone.setBrainInJarXP(brain, xpBrain - added);
                }
            }
        }
    }

    public void drainAllXPFromBrain(TileJarBrain brain) {
        int xp = brain.xp - 1;
        if (xp > 0) {
            TileEntityAmnesiacStone.setBrainInJarXP(brain, 1);
            this.spawnExperience(xp);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te;
                if (dir == ForgeDirection.UP || !((te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) instanceof TileEntityXPStone)) continue;
                int drained = ((TileEntityXPStone)te).quickDrain();
                this.spawnExperience(drained);
            }
        }
    }

    public void spawnExperience(int xp) {
        TjUtil.spawnExperienceIntoWorld(xp, this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, false);
    }

    public int getComparatorStrength() {
        return this.comparatorStrength;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.comparatorStrength = nbttagcompound.func_74765_d("compStr");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("compStr", (short)this.comparatorStrength);
    }

    public static void setBrainInJarXP(TileJarBrain brain, int xp) {
        brain.xp = xp;
        brain.func_145831_w().func_147471_g(brain.field_145851_c, brain.field_145848_d, brain.field_145849_e);
        brain.func_70296_d();
    }

    public static class PairedItemToDrain {
        public EntityItem entity;
        public ItemDrainResult result;

        public PairedItemToDrain(EntityItem entity, ItemDrainResult result) {
            this.entity = entity;
            this.result = result;
        }
    }

    public static class ItemDrainResult {
        public int xp;
        public ItemStack replacement;
        public boolean replacementUseContainer = false;
    }
}

