/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.utils.LabeledPositionedStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public abstract class BaseProduceRecipeHandler
extends TemplateRecipeHandler {
    private final ISpeciesRoot speciesRoot;
    private final Map<Item, Collection<IAlleleSpecies>> cache;

    public BaseProduceRecipeHandler(ISpeciesRoot root) {
        this.speciesRoot = root;
        this.cache = this.getProduceCache();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
            return;
        }
        if (!outputId.equals(this.getRecipeIdent())) {
            return;
        }
        for (IAlleleSpecies iAlleleSpecies : this.getAllSpecies()) {
            CachedProduceRecipe rec = new CachedProduceRecipe(iAlleleSpecies);
            if (rec.isNoOutput()) continue;
            this.arecipes.add(rec);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedProduceRecipe crecipe = (CachedProduceRecipe)((Object)this.arecipes.get(recipe));
        for (LabeledPositionedStack positionedStack : crecipe.getProducts()) {
            if (stack != positionedStack.item) continue;
            currenttip.addAll(positionedStack.getTooltip());
        }
        return currenttip;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (this.cache == null) {
            return;
        }
        if (result == null) {
            AddonForestry.instance.logWarning("loadCraftingRecipes() called with null, something is FUBAR.", new Object[0]);
            return;
        }
        if (!this.cache.containsKey(result.func_77973_b())) {
            return;
        }
        block0: for (IAlleleSpecies species : this.cache.get(result.func_77973_b())) {
            CachedProduceRecipe recipe = new CachedProduceRecipe(species);
            for (LabeledPositionedStack stack : recipe.products) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)stack.item, (ItemStack)result)) continue;
                this.arecipes.add(recipe);
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!this.speciesRoot.isMember(ingredient)) {
            return;
        }
        IIndividual member = this.speciesRoot.getMember(ingredient);
        if (member == null || member.getGenome() == null || member.getGenome().getPrimary() == null) {
            AddonForestry.instance.logWarning("Individual or genome is null searching recipe for %s", ingredient.toString());
            return;
        }
        this.arecipes.add(new CachedProduceRecipe(member.getGenome().getPrimary()));
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(48, 22, 21, 15), this.getRecipeIdent(), new Object[0]));
    }

    public void drawExtras(int recipe) {
        CachedProduceRecipe rec = (CachedProduceRecipe)((Object)this.arecipes.get(recipe));
        rec.producer.drawLabel();
        for (LabeledPositionedStack stack : rec.products) {
            stack.drawLabel();
        }
        FontRenderer f = Minecraft.func_71410_x().field_71466_p;
        f.func_78276_b("Prod:", 65, 12, 0xFFFFFF);
        f.func_78276_b("Spec:", 65, 40, 0xFFF200);
    }

    public abstract String getRecipeIdent();

    public abstract Collection<? extends IAlleleSpecies> getAllSpecies();

    public abstract Map<Item, Collection<IAlleleSpecies>> getProduceCache();

    public String getGuiTexture() {
        return "neiaddons:textures/gui/products.png";
    }

    public final String getRecipeName() {
        return I18n.func_135052_a((String)("bdew.neiaddons.produce." + this.getRecipeIdent()), (Object[])new Object[0]);
    }

    public class CachedProduceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private LabeledPositionedStack producer;
        private final ArrayList<LabeledPositionedStack> products;

        public CachedProduceRecipe(IAlleleSpecies species) {
            IJubilanceProvider provider;
            super((TemplateRecipeHandler)BaseProduceRecipeHandler.this);
            ItemStack producerStack = GeneticsUtils.stackFromSpecies(species, GeneticsUtils.RecipePosition.Producer);
            if (producerStack == null) {
                AddonForestry.instance.logWarning("Producer is null... wtf? species = %s", species.getUID());
            } else {
                this.producer = new LabeledPositionedStack(producerStack, 22, 19, species.getName(), 13);
            }
            this.products = new ArrayList();
            int i = 0;
            for (Map.Entry<ItemStack, Float> product : Utils.mergeStacks(GeneticsUtils.getProduceFromSpecies(species)).entrySet()) {
                String label = String.format("%.1f%%", Float.valueOf(product.getValue().floatValue() * 100.0f));
                this.products.add(new LabeledPositionedStack(product.getKey(), 96 + 22 * i++, 8, label, 10));
            }
            String jubilance = null;
            if (species instanceof IAlleleBeeSpeciesCustom && (provider = ((IAlleleBeeSpeciesCustom)species).getJubilanceProvider()) != null) {
                jubilance = provider.getDescription();
            }
            i = 0;
            for (Map.Entry<ItemStack, Float> product : Utils.mergeStacks(GeneticsUtils.getSpecialtyFromSpecies(species)).entrySet()) {
                String label = String.format("%.1f%%", Float.valueOf(product.getValue().floatValue() * 100.0f));
                if (jubilance != null) {
                    this.products.add(new LabeledPositionedStack(product.getKey(), 96 + 22 * i++, 36, label, 10, EnumChatFormatting.GRAY + jubilance));
                    continue;
                }
                this.products.add(new LabeledPositionedStack(product.getKey(), 96 + 22 * i++, 36, label, 10));
            }
        }

        public boolean isNoOutput() {
            return this.products.size() == 0;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.add(this.producer);
            return list;
        }

        public ArrayList<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            if (this.products.size() > 1) {
                for (int i = 1; i < this.products.size(); ++i) {
                    list.add(this.products.get(i));
                }
            }
            return list;
        }

        public PositionedStack getResult() {
            if (this.products.size() > 0) {
                return this.products.get(0);
            }
            return null;
        }

        public ArrayList<LabeledPositionedStack> getProducts() {
            return this.products;
        }
    }
}

