/*
 * Decompiled with CFR 0.152.
 */
package mantle.pulsar.internal.logging;

import mantle.pulsar.internal.logging.ILogger;
import mantle.pulsar.internal.logging.JULLogger;
import mantle.pulsar.internal.logging.Log4jLogger;

public class LogManager {
    private static final boolean useLog4j2;

    private LogManager() {
    }

    public static ILogger getLogger(String name) {
        if (useLog4j2) {
            return new Log4jLogger(name);
        }
        return new JULLogger(name);
    }

    static {
        boolean l4j = false;
        try {
            Class<?> cl = Class.forName("org.apache.logging.log4j.LogManager");
            if (cl == null) {
                throw new ClassNotFoundException("This should never happen...");
            }
            l4j = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        useLog4j2 = l4j;
    }
}

