/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.core.world.chunk.ChunkHelper;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;

public abstract class TagWorld
extends Tag {
    @Override
    public String getCategory() {
        return "world";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Name().setName("worldname"));
        TagRegistry.INSTANCE.register(new Size().setName("worldsize"));
        TagRegistry.INSTANCE.register(new SizeMB().setName("worldsizemb"));
        TagRegistry.INSTANCE.register(new Seed().setName("seed"));
        TagRegistry.INSTANCE.register(new Difficulty().setName("difficulty"));
        TagRegistry.INSTANCE.register(new DifficultyId().setName("difficultyid"));
        TagRegistry.INSTANCE.register(new Dimension().setName("dimension"));
        TagRegistry.INSTANCE.register(new DimensionId().setName("dimensionid"));
        TagRegistry.INSTANCE.register(new Biome().setName("biome"));
        TagRegistry.INSTANCE.register(new BiomeId().setName("biomeid"));
        TagRegistry.INSTANCE.register(new Daytime().setName("daytime"));
        TagRegistry.INSTANCE.register(new Raining().setName("raining"));
        TagRegistry.INSTANCE.register(new Thundering().setName("thundering"));
        TagRegistry.INSTANCE.register(new Snowing().setName("snowing"));
        TagRegistry.INSTANCE.register(new NextRain().setName("nextrain"));
        TagRegistry.INSTANCE.register(new Slimes().setName("slimes"));
        TagRegistry.INSTANCE.register(new Hardcore().setName("hardcore"));
        TagRegistry.INSTANCE.register(new Temperature().setName("temperature"));
        TagRegistry.INSTANCE.register(new LocalTemperature().setName("localtemperature"));
        TagRegistry.INSTANCE.register(new Humidity().setName("humidity"));
    }

    public static class Name
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)Name.player.field_71093_bK)) != null) {
                return worldServer.func_72912_H().func_76065_j();
            }
            return world.func_72912_H().func_76065_j();
        }
    }

    public static class Size
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)Size.player.field_71093_bK)) != null) {
                return String.valueOf(worldServer.func_72912_H().func_76092_g());
            }
            return String.valueOf(world.func_72912_H().func_76092_g());
        }
    }

    public static class SizeMB
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)SizeMB.player.field_71093_bK)) != null) {
                return String.format(Locale.ENGLISH, "%.1f", (double)worldServer.func_72912_H().func_76092_g() / 1048576.0);
            }
            return String.format(Locale.ENGLISH, "%.1f", (double)world.func_72912_H().func_76092_g() / 1048576.0);
        }
    }

    public static class Seed
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(seed);
        }
    }

    public static class Difficulty
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)Difficulty.player.field_71093_bK)) != null) {
                return I18n.func_135052_a((String)worldServer.field_73013_u.func_151526_b(), (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)Difficulty.minecraft.field_71474_y.field_74318_M.func_151526_b(), (Object[])new Object[0]);
        }
    }

    public static class DifficultyId
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)DifficultyId.player.field_71093_bK)) != null) {
                return String.valueOf(worldServer.field_73013_u.func_151525_a());
            }
            return String.valueOf(DifficultyId.minecraft.field_71474_y.field_74318_M.func_151525_a());
        }
    }

    public static class Dimension
    extends TagWorld {
        @Override
        public String getValue() {
            return Dimension.world.field_73011_w.func_80007_l();
        }
    }

    public static class DimensionId
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(DimensionId.player.field_71093_bK);
        }
    }

    public static class Biome
    extends TagWorld {
        @Override
        public String getValue() {
            return Biome.world.func_72807_a((int)Biome.playerPosition.x, (int)Biome.playerPosition.z).field_76791_y;
        }
    }

    public static class BiomeId
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(BiomeId.world.func_72807_a((int)BiomeId.playerPosition.x, (int)BiomeId.playerPosition.z).field_76756_M);
        }
    }

    public static class Daytime
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72967_a(1.0f) < 4);
        }
    }

    public static class Raining
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72896_J() && world.func_72807_a(Raining.playerPosition.x, Raining.playerPosition.z).func_76738_d());
        }
    }

    public static class Thundering
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72911_I() && world.func_72807_a(Thundering.playerPosition.x, Thundering.playerPosition.z).func_76738_d());
        }
    }

    public static class Snowing
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72896_J() && world.func_72807_a(Snowing.playerPosition.x, Snowing.playerPosition.z).func_76746_c());
        }
    }

    public static class NextRain
    extends TagWorld {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getValue() {
            int seconds;
            if (server == null) {
                if (!hasNextRainTime) return "?";
                seconds = nextRainTime / 20;
            } else {
                seconds = NextRain.server.field_71305_c[0].func_72912_H().func_76083_p() / 20;
            }
            if (seconds < 60) {
                return String.format(Locale.ENGLISH, "%ds", seconds);
            }
            if (seconds >= 3600) return String.format(Locale.ENGLISH, "%dh", seconds / 3600);
            return String.format(Locale.ENGLISH, "%dm", seconds / 60);
        }
    }

    public static class Slimes
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(hasSeed && ChunkHelper.isSlimeChunk((long)seed, (int)(Slimes.playerPosition.x >> 4), (int)(Slimes.playerPosition.z >> 4)) || Slimes.world.func_72807_a((int)Slimes.playerPosition.x, (int)Slimes.playerPosition.z).field_76756_M == BiomeGenBase.field_76780_h.field_76756_M);
        }
    }

    public static class Hardcore
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72912_H().func_76093_s());
        }
    }

    public static class Temperature
    extends TagWorld {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.0f", Float.valueOf(Temperature.world.func_72807_a((int)Temperature.playerPosition.x, (int)Temperature.playerPosition.z).field_76750_F * 100.0f));
        }
    }

    public static class LocalTemperature
    extends TagWorld {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(world.func_72807_a(LocalTemperature.playerPosition.x, LocalTemperature.playerPosition.z).func_150564_a(LocalTemperature.playerPosition.x & 0xF, (int)Math.round(LocalTemperature.player.field_70121_D.field_72338_b), LocalTemperature.playerPosition.z & 0xF) * 100.0f));
        }
    }

    public static class Humidity
    extends TagWorld {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.0f", Float.valueOf(Humidity.world.func_72807_a((int)Humidity.playerPosition.x, (int)Humidity.playerPosition.z).field_76751_G * 100.0f));
        }
    }
}

