/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.utils.ICopy;
import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.utils.serialization.IByteBufDeserializer;
import com.cleanroommc.modularui.utils.serialization.IByteBufSerializer;
import com.cleanroommc.modularui.utils.serialization.IEquals;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericCollectionSyncHandler<T, C extends Collection<T>>
extends ValueSyncHandler<C> {
    private final Supplier<C> getter;
    private final Consumer<C> setter;
    private final IByteBufDeserializer<T> deserializer;
    private final IByteBufSerializer<T> serializer;
    private final IEquals<T> equals;
    private final ICopy<T> copy;

    protected GenericCollectionSyncHandler(@NotNull Supplier<C> getter, @Nullable Consumer<C> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable IEquals<T> equals, @Nullable ICopy<T> copy) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = setter;
        this.deserializer = deserializer;
        this.serializer = serializer;
        this.equals = equals != null ? IEquals.wrapNullSafe(equals) : Objects::equals;
        this.copy = copy != null ? copy : ICopy.ofSerializer(serializer, deserializer);
    }

    @Override
    public void setValue(C value, boolean setSource, boolean sync) {
        this.setCache(value);
        this.onSetCache(value, setSource, sync);
    }

    protected abstract void setCache(C var1);

    protected void onSetCache(C value, boolean setSource, boolean sync) {
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        if (sync) {
            this.sync(0, this::write);
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        Collection c = (Collection)this.getter.get();
        if (isFirstSync || this.didValuesChange(c)) {
            this.setValue((C)c, false, false);
            return true;
        }
        return false;
    }

    protected abstract boolean didValuesChange(C var1);

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        Object c = this.getValue();
        buffer.func_150787_b(c.size());
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            this.serializer.serialize(buffer, t);
        }
    }

    @Override
    public abstract C getValue();

    public boolean areValuesEqual(T a, T b) {
        return this.equals.areEqual(a, b);
    }

    protected T deserializeValue(PacketBuffer buffer) throws IOException {
        return this.deserializer.deserialize(buffer);
    }

    protected T copyValue(T value) {
        return this.copy.createDeepCopy(value);
    }

    public static class Builder<T, C extends Collection<T>, B extends Builder<T, C, B>> {
        protected Supplier<C> getter;
        protected Consumer<C> setter;
        protected IByteBufDeserializer<T> deserializer;
        protected IByteBufSerializer<T> serializer;
        protected IEquals<T> equals;
        protected ICopy<T> copy;

        public B getter(Supplier<C> getter) {
            this.getter = getter;
            return this.getSelf();
        }

        public B setter(Consumer<C> setter) {
            this.setter = setter;
            return this.getSelf();
        }

        public B deserializer(IByteBufDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this.getSelf();
        }

        public B serializer(IByteBufSerializer<T> serializer) {
            this.serializer = serializer;
            return this.getSelf();
        }

        protected B equals(IEquals<T> equals) {
            this.equals = equals;
            return this.getSelf();
        }

        public B adapter(IByteBufAdapter<T> adapter) {
            return ((Builder)((Builder)this.deserializer(adapter)).serializer(adapter)).equals(adapter);
        }

        public B copy(ICopy<T> copy) {
            this.copy = copy;
            return this.getSelf();
        }

        public B immutableCopy() {
            return this.copy(ICopy.immutable());
        }

        protected B getSelf() {
            return (B)this;
        }
    }
}

