/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block;

import de.katzenpapst.amunra.block.SubBlock;
import de.katzenpapst.amunra.item.ItemDamagePair;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public class SubBlockDropItem
extends SubBlock {
    protected Random rand = new Random();
    protected ItemDamagePair droppedItems = null;
    protected int baseDropRateMin = 1;
    protected float bonusDropMultiplier = 1.0f;
    protected int xpDropMin = 0;
    protected int xpDropMax = 0;
    protected boolean isValuable = false;

    public SubBlockDropItem(String name, String texture) {
        super(name, texture);
    }

    public SubBlockDropItem(String name, String texture, String tool, int harvestLevel) {
        super(name, texture, tool, harvestLevel);
    }

    public SubBlockDropItem(String name, String texture, String tool, int harvestLevel, float hardness, float resistance) {
        super(name, texture, tool, harvestLevel, hardness, resistance);
    }

    @Override
    public boolean dropsSelf() {
        return this.droppedItems == null;
    }

    public SubBlockDropItem setDroppedItem(ItemDamagePair item) {
        this.droppedItems = item;
        return this;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        int result = (int)((float)(this.func_149745_a(random) * MathHelper.func_76136_a((Random)random, (int)1, (int)(fortune + 2))) * this.bonusDropMultiplier);
        if (result < this.baseDropRateMin) {
            result = this.baseDropRateMin;
        }
        return result;
    }

    public int func_149745_a(Random random) {
        return this.baseDropRateMin;
    }

    public int func_149692_a(int meta) {
        return this.droppedItems != null ? this.droppedItems.getDamage() : super.func_149692_a(meta);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return this.droppedItems != null ? this.droppedItems.getItem() : super.func_149650_a(meta, random, fortune);
    }

    public SubBlockDropItem setDroppedItem(Item item) {
        this.droppedItems = new ItemDamagePair(item, 0);
        return this;
    }

    public SubBlockDropItem setMinDropRate(int val) {
        this.baseDropRateMin = val;
        return this;
    }

    public SubBlockDropItem setBonusMultiplier(float val) {
        this.bonusDropMultiplier = val;
        return this;
    }

    public SubBlockDropItem setXpDrop(int dropMin, int dropMax) {
        this.xpDropMin = dropMin;
        this.xpDropMax = dropMax;
        return this;
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        if (!this.dropsSelf()) {
            if (this.xpDropMin <= this.xpDropMax) {
                return this.xpDropMin;
            }
            MathHelper.func_76136_a((Random)this.rand, (int)this.xpDropMin, (int)this.xpDropMax);
        }
        return 0;
    }

    @Override
    public boolean isValueable(int metadata) {
        return this.isValuable;
    }

    public SubBlockDropItem setIsValueable(boolean set) {
        this.isValuable = set;
        return this;
    }
}

