/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.NetworkRenderer;
import net.minecraft.world.World;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class SystemRenderEventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)AmunRa.instance.asteroidBeltMehen) || renderEvent.celestialBody.equals((Object)AmunRa.instance.moonBaalRings)) {
            this.drawAsteroidRings(renderEvent, renderEvent.celestialBody);
        }
    }

    protected void drawAsteroidRings(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody) {
        float temp;
        int i;
        Vector3f mapPos = renderEvent.parentOffset;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
            GL11.glColor4f((float)0.7f, (float)0.0f, (float)0.0f, (float)0.5f);
        } else {
            GL11.glColor4f((float)0.3f, (float)0.1f, (float)0.1f, (float)1.0f);
        }
        renderEvent.setCanceled(true);
        GL11.glBegin((int)2);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        float min = 0.0f;
        float max = 0.0f;
        if (aroundBody instanceof Planet) {
            min = 72.0f;
            max = 78.0f;
        } else if (aroundBody instanceof Moon) {
            max = 0.6666667f;
            min = 0.5263158f;
        }
        float x = max * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        float y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)0.7f, (float)0.0f, (float)0.0f, (float)0.1f);
        GL11.glBegin((int)7);
        x = min * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        y = 0.0f;
        float x2 = max * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        float y2 = 0.0f;
        for (int i2 = 0; i2 < 90; ++i2) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
            temp = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBodyRender(CelestialBodyRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)AmunRa.instance.asteroidBeltMehen) || renderEvent.celestialBody.equals((Object)AmunRa.instance.moonBaalRings)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onSpecialRender(ClientProxyCore.EventSpecialRender event) {
        NetworkRenderer.renderNetworks((World)FMLClientHandler.instance().getClient().field_71441_e, (float)event.partialTicks);
    }
}

