/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.proxy;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.client.fx.EntityFXGravityDust;
import de.katzenpapst.amunra.client.fx.EntityFXMothershipIonFlame;
import de.katzenpapst.amunra.client.fx.EntityFXMothershipJetFire;
import de.katzenpapst.amunra.client.renderer.BlockRendererARChest;
import de.katzenpapst.amunra.client.renderer.BlockRendererDummy;
import de.katzenpapst.amunra.client.renderer.BlockRendererMothershipBooster;
import de.katzenpapst.amunra.client.renderer.BlockRendererMultiOre;
import de.katzenpapst.amunra.client.renderer.RenderARChest;
import de.katzenpapst.amunra.client.renderer.RenderArtificalGravity;
import de.katzenpapst.amunra.client.renderer.RenderBlockScale;
import de.katzenpapst.amunra.client.renderer.RenderHydroponics;
import de.katzenpapst.amunra.client.renderer.RenderLaserArrow;
import de.katzenpapst.amunra.client.renderer.RenderMothershipBooster;
import de.katzenpapst.amunra.client.renderer.RenderMothershipJet;
import de.katzenpapst.amunra.client.renderer.RenderShuttle;
import de.katzenpapst.amunra.client.renderer.RenderShuttleDock;
import de.katzenpapst.amunra.client.renderer.item.ItemRendererJet;
import de.katzenpapst.amunra.client.renderer.item.ItemRendererShuttle;
import de.katzenpapst.amunra.client.renderer.item.ItemRendererSpecial1;
import de.katzenpapst.amunra.client.sound.TickableLoopedSound;
import de.katzenpapst.amunra.command.CommandCelestialBodyInfo;
import de.katzenpapst.amunra.entity.EntityBaseLaserArrow;
import de.katzenpapst.amunra.entity.EntityOsirisBossFireball;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttleFake;
import de.katzenpapst.amunra.event.SystemRenderEventHandler;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.item.SubItemToggle;
import de.katzenpapst.amunra.mob.entity.EntityARVillager;
import de.katzenpapst.amunra.mob.entity.EntityAlienBug;
import de.katzenpapst.amunra.mob.entity.EntityMummyBoss;
import de.katzenpapst.amunra.mob.entity.EntityPorcodon;
import de.katzenpapst.amunra.mob.entity.EntityRobotVillager;
import de.katzenpapst.amunra.mob.entity.EntitySentry;
import de.katzenpapst.amunra.mob.render.RenderARVillager;
import de.katzenpapst.amunra.mob.render.RenderBug;
import de.katzenpapst.amunra.mob.render.RenderFirstBoss;
import de.katzenpapst.amunra.mob.render.RenderPorcodon;
import de.katzenpapst.amunra.mob.render.RenderRobotVillager;
import de.katzenpapst.amunra.mob.render.RenderSentry;
import de.katzenpapst.amunra.proxy.ARSidedProxy;
import de.katzenpapst.amunra.tick.TickHandlerClient;
import de.katzenpapst.amunra.tile.TileEntityARChest;
import de.katzenpapst.amunra.tile.TileEntityARChestLarge;
import de.katzenpapst.amunra.tile.TileEntityBlockScale;
import de.katzenpapst.amunra.tile.TileEntityGravitation;
import de.katzenpapst.amunra.tile.TileEntityHydroponics;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineBooster;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineBoosterIon;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineIon;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineJet;
import de.katzenpapst.amunra.tile.TileEntityShuttleDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEntityFake;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderFireball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends ARSidedProxy {
    private static IModelCustom rocketModel = null;
    private static IModelCustom engineModel = null;
    private static IModelCustom engineModelIon = null;
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    private static int jumpTimer = 0;
    public static final float GRAVITY_POS_FACTOR = 1.5999999f;
    public static final float GRAVITY_NEG_FACTOR = 1.08f;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCelestialBodyInfo());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BlockRendererMultiOre myISBRH = new BlockRendererMultiOre();
        RenderingRegistry.registerBlockHandler((int)myISBRH.getRenderId(), (ISimpleBlockRenderingHandler)myISBRH);
        BlockRendererDummy dummyRenderer = new BlockRendererDummy();
        RenderingRegistry.registerBlockHandler((int)dummyRenderer.getRenderId(), (ISimpleBlockRenderingHandler)dummyRenderer);
        BlockRendererMothershipBooster msBoosterRenderer = new BlockRendererMothershipBooster();
        RenderingRegistry.registerBlockHandler((int)msBoosterRenderer.getRenderId(), (ISimpleBlockRenderingHandler)msBoosterRenderer);
        BlockRendererARChest chestRenderer = new BlockRendererARChest();
        RenderingRegistry.registerBlockHandler((int)chestRenderer.getRenderId(), (ISimpleBlockRenderingHandler)chestRenderer);
        SystemRenderEventHandler clientEventHandler = new SystemRenderEventHandler();
        FMLCommonHandler.instance().bus().register((Object)clientEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerClient());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        rocketModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("amunra", "models/shuttle2.obj"));
        engineModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("amunra", "models/jet.obj"));
        engineModelIon = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("amunra", "models/jet-ion.obj"));
        ClientProxy.registerEntityRenderers();
        ClientProxy.registerItemRenderers();
    }

    public static void registerItemRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)ARItems.shuttleItem, (IItemRenderer)new ItemRendererShuttle(rocketModel));
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ARBlocks.blockShuttleDock.getBlock()), (IItemRenderer)new ItemRendererSpecial1());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ARBlocks.metaBlockMothershipEngineJet), (IItemRenderer)new ItemRendererJet(new IModelCustom[]{engineModel, engineModelIon}, new ResourceLocation[]{new ResourceLocation("amunra", "textures/model/jet.png"), new ResourceLocation("amunra", "textures/model/jet-ion.png")}));
    }

    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityPorcodon.class, (Render)new RenderPorcodon());
        RenderingRegistry.registerEntityRenderingHandler(EntityARVillager.class, (Render)new RenderARVillager());
        RenderingRegistry.registerEntityRenderingHandler(EntityRobotVillager.class, (Render)new RenderRobotVillager());
        RenderingRegistry.registerEntityRenderingHandler(EntitySentry.class, (Render)new RenderSentry());
        RenderingRegistry.registerEntityRenderingHandler(EntityAlienBug.class, (Render)new RenderBug());
        RenderingRegistry.registerEntityRenderingHandler(EntityMummyBoss.class, (Render)new RenderFirstBoss());
        RenderingRegistry.registerEntityRenderingHandler(EntityOsirisBossFireball.class, (Render)new RenderFireball(2.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityBaseLaserArrow.class, (Render)new RenderLaserArrow());
        RenderingRegistry.registerEntityRenderingHandler(EntityShuttle.class, (Render)new RenderShuttle(rocketModel, "amunra", "shuttle"));
        RenderingRegistry.registerEntityRenderingHandler(EntityShuttleFake.class, (Render)new RenderEntityFake());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMothershipEngineJet.class, (TileEntitySpecialRenderer)new RenderMothershipJet(engineModel, new ResourceLocation("amunra", "textures/model/jet.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMothershipEngineBooster.class, (TileEntitySpecialRenderer)new RenderMothershipBooster(new ResourceLocation("amunra", "textures/blocks/jet-base.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMothershipEngineIon.class, (TileEntitySpecialRenderer)new RenderMothershipJet(engineModelIon, new ResourceLocation("amunra", "textures/model/jet-ion.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMothershipEngineBoosterIon.class, (TileEntitySpecialRenderer)new RenderMothershipBooster(new ResourceLocation("amunra", "textures/blocks/jet-base-ion.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockScale.class, (TileEntitySpecialRenderer)new RenderBlockScale());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityShuttleDock.class, (TileEntitySpecialRenderer)new RenderShuttleDock());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHydroponics.class, (TileEntitySpecialRenderer)new RenderHydroponics());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGravitation.class, (TileEntitySpecialRenderer)new RenderArtificalGravity());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityARChest.class, (TileEntitySpecialRenderer)new RenderARChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityARChestLarge.class, (TileEntitySpecialRenderer)new RenderARChest());
    }

    @Override
    public void spawnParticles(ARSidedProxy.ParticleType type, World world, Vector3 pos, Vector3 motion) {
        if (!world.field_72995_K) {
            return;
        }
        EntityFX resultEntity = null;
        switch (type) {
            case PT_MOTHERSHIP_JET_FLAME: {
                resultEntity = new EntityFXMothershipJetFire(world, pos, motion);
                break;
            }
            case PT_MOTHERSHIP_ION_FLAME: {
                resultEntity = new EntityFXMothershipIonFlame(world, pos, motion, 2.5f);
                break;
            }
            case PT_GRAVITY_DUST: {
                resultEntity = new EntityFXGravityDust(world, pos, motion);
                break;
            }
            default: {
                return;
            }
        }
        resultEntity.field_70169_q = resultEntity.field_70165_t;
        resultEntity.field_70167_r = resultEntity.field_70163_u;
        resultEntity.field_70166_s = resultEntity.field_70161_v;
        Minecraft.func_71410_x().field_71452_i.func_78873_a(resultEntity);
    }

    @Override
    public void playTileEntitySound(TileEntity tile, ResourceLocation resource) {
        if (!tile.func_145831_w().field_72995_K) {
            return;
        }
        TickableLoopedSound snd = new TickableLoopedSound(tile, resource);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)snd);
    }

    private boolean hasActiveGravityDisabler(EntityPlayerSP p) {
        for (ItemStack stack : p.field_71071_by.field_70462_a) {
            SubItemToggle si;
            if (!ARItems.gravityDisabler.isSameItem(stack) || !(si = (SubItemToggle)ARItems.gravityDisabler.getSubItem()).getState(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handlePlayerArtificalGravity(EntityPlayer player, double gravity) {
        if (player instanceof EntityPlayerSP) {
            double fu;
            if (!Minecraft.func_71410_x().field_71439_g.equals((Object)player)) {
                return;
            }
            EntityPlayerSP p = (EntityPlayerSP)player;
            if (this.hasActiveGravityDisabler(p)) {
                return;
            }
            TickHandlerClient.playerGravityState = 2;
            if (p.field_70170_p.field_73011_w instanceof IZeroGDimension) {
                if (p.field_71158_b.field_78901_c && p.field_70122_E && jumpTimer <= 0) {
                    p.func_70664_aZ();
                    jumpTimer = 10;
                } else if (jumpTimer > 0) {
                    --jumpTimer;
                }
            }
            fu = (fu = gravity) < 0.0 ? (fu *= (double)1.08f) : (fu *= 1.5999999046325684);
            p.field_70181_x += fu;
        }
    }

    @Override
    public boolean doCancelGravityEvent(EntityPlayer player) {
        return TickHandlerClient.playerGravityState > 0;
    }
}

