/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world;

import cpw.mods.fml.common.FMLCommonHandler;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import de.katzenpapst.amunra.tile.TileEntityShuttleDock;
import de.katzenpapst.amunra.vec.Vector3int;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class ShuttleDockHandler
extends WorldSavedData {
    public static final String saveDataID = "ShuttleDock";
    private static Map<Integer, Map<Vector3int, Boolean>> tileMap = new HashMap<Integer, Map<Vector3int, Boolean>>();

    public ShuttleDockHandler(String id) {
        super(id);
    }

    protected static void markInstanceDirty() {
        TickHandlerServer.dockData.func_76186_a(true);
    }

    public void func_76184_a(NBTTagCompound p_76184_1_) {
        NBTTagList tagList = p_76184_1_.func_150295_c("DockList", 10);
        tileMap.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound dimensionNbt = tagList.func_150305_b(i);
            int dimID = dimensionNbt.func_74762_e("DimID");
            NBTTagList posList = dimensionNbt.func_150295_c("PosList", 10);
            HashMap<Vector3int, Boolean> curList = new HashMap<Vector3int, Boolean>();
            for (int j = 0; j < posList.func_74745_c(); ++j) {
                NBTTagCompound posTag = posList.func_150305_b(j);
                int posX = posTag.func_74762_e("PosX");
                int posY = posTag.func_74762_e("PosY");
                int posZ = posTag.func_74762_e("PosZ");
                boolean available = posTag.func_74767_n("isAvailable");
                Vector3int pos = new Vector3int(posX, posY, posZ);
                curList.put(pos, available);
            }
            tileMap.put(dimID, curList);
        }
    }

    public void func_76187_b(NBTTagCompound p_76187_1_) {
        NBTTagList totalNbtList = new NBTTagList();
        for (int dimID : tileMap.keySet()) {
            NBTTagCompound dimTag = new NBTTagCompound();
            dimTag.func_74768_a("DimID", dimID);
            Map<Vector3int, Boolean> curList = tileMap.get(dimID);
            NBTTagList posNbtList = new NBTTagList();
            for (Vector3int pos : curList.keySet()) {
                boolean avail = curList.get(pos);
                NBTTagCompound posTag = new NBTTagCompound();
                posTag.func_74768_a("PosX", pos.x);
                posTag.func_74768_a("PosY", pos.y);
                posTag.func_74768_a("PosZ", pos.z);
                posTag.func_74757_a("isAvailable", avail);
                posNbtList.func_74742_a((NBTBase)posTag);
            }
            dimTag.func_74782_a("PosList", (NBTBase)posNbtList);
            totalNbtList.func_74742_a((NBTBase)dimTag);
        }
        p_76187_1_.func_74782_a("DockList", (NBTBase)totalNbtList);
    }

    public static boolean getStoredAvailability(TileEntityShuttleDock dock) {
        if (!dock.func_145831_w().field_72995_K) {
            int dimID = dock.func_145831_w().field_73011_w.field_76574_g;
            Vector3int pos = new Vector3int(dock.field_145851_c, dock.field_145848_d, dock.field_145849_e);
            if (!tileMap.containsKey(dimID)) {
                return false;
            }
            Map<Vector3int, Boolean> set = tileMap.get(dimID);
            if (!set.containsKey(pos)) {
                return false;
            }
            return set.get(pos);
        }
        return false;
    }

    public static void setStoredAvailability(TileEntityShuttleDock dock, boolean isAvailable) {
        if (!dock.func_145831_w().field_72995_K) {
            if (dock.func_145837_r()) {
                return;
            }
            int dimID = dock.func_145831_w().field_73011_w.field_76574_g;
            Vector3int pos = new Vector3int(dock.field_145851_c, dock.field_145848_d, dock.field_145849_e);
            if (!tileMap.containsKey(dimID)) {
                HashMap<Vector3int, Boolean> set = new HashMap<Vector3int, Boolean>();
                set.put(pos, isAvailable);
                tileMap.put(dimID, set);
            } else {
                Map<Vector3int, Boolean> set = tileMap.get(dimID);
                set.put(pos, isAvailable);
            }
            ShuttleDockHandler.markInstanceDirty();
        }
    }

    public static void addDock(TileEntityShuttleDock dock) {
        ShuttleDockHandler.setStoredAvailability(dock, dock.isAvailable());
    }

    protected static void removeDock(int dimID, int x, int y, int z) {
        if (tileMap.containsKey(dimID)) {
            Vector3int pos = new Vector3int(x, y, z);
            tileMap.get(dimID).remove(pos);
            ShuttleDockHandler.markInstanceDirty();
        }
    }

    public static void removeDock(TileEntityShuttleDock dock) {
        if (!dock.func_145831_w().field_72995_K) {
            int dimID = dock.func_145831_w().field_73011_w.field_76574_g;
            ShuttleDockHandler.removeDock(dimID, dock.field_145851_c, dock.field_145848_d, dock.field_145849_e);
        }
    }

    public static Vector3int findAvailableDock(int dimID) {
        Map<Vector3int, Boolean> positions;
        if (tileMap.containsKey(dimID) && (positions = tileMap.get(dimID)).size() > 0) {
            MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer ws = theServer.func_71218_a(dimID);
            for (Vector3int pos : positions.keySet()) {
                Boolean avail;
                TileEntity te = ws.func_147438_o(pos.x, pos.y, pos.z);
                if (!(te instanceof TileEntityShuttleDock ? ((TileEntityShuttleDock)te).isAvailable() : (avail = positions.get(pos)) != false)) continue;
                return pos;
            }
        }
        return null;
    }
}

