/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world;

import cpw.mods.fml.client.FMLClientHandler;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.RingsRenderInfo;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class SkyProviderDynamic
extends IRenderHandler {
    protected List<ResourceLocation> asteroidTextures = null;
    protected RenderType rType = RenderType.PLANET;
    protected boolean hasHorizon = true;
    public static final double PI_HALF = 1.5707963267948966;
    public static final double PI_DOUBLE = Math.PI * 2;
    public static final float PLANET_AXIS_ANGLE_DEFAULT = -19.0f;
    public static final float PLANET_AXIS_ANGLE_ASTEROID = -90.0f;
    public static final float MOON_AXIS_ANGLE_ASTEROID = 10.0f;
    public static final float MOON_AXIS_ANGLE_DEFAULT = 10.0f;
    protected final List<BodyRenderTask> farBodiesToRender = new ArrayList<BodyRenderTask>();
    protected final List<BodyRenderTask> nearBodiesToRender = new ArrayList<BodyRenderTask>();
    private static float planetAxisAngle = -19.0f;
    private static float moonAxisAngle = 10.0f;
    private final double parentSunFactor = 6.0;
    private final double parentPlanetFactor = 80.0;
    private final double siblingPlanetFactor = 1.0;
    private final double siblingStarFactor = 4.0;
    private final double siblingMoonFactor = 80.0;
    private final double childMoonFactor = 400.0;
    private final double childPlanetFactor = 5.0;
    public int starList;
    public int glSkyList;
    public int glSkyList2;
    protected float sunSize;
    protected SolarSystem curSystem;
    protected CelestialBody curBody;
    protected CelestialBody curBodyPlanet;
    protected float curBodyDistance;
    protected float boxWidthHalf = 311.0f;
    protected boolean hasAtmosphere = true;
    protected Vec3 planetSkyColor = null;
    protected float currentCelestialAngle = 0.0f;
    protected IGalacticraftWorldProvider worldProvider;
    protected boolean isAsteroidBelt;
    protected boolean isAsteroidBeltMoon;
    public int asteroidList = 0;

    public static double fixAngle(double angle) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public SkyProviderDynamic(IGalacticraftWorldProvider worldProvider) {
        int displayLists;
        this.curBody = worldProvider.getCelestialBody();
        this.worldProvider = worldProvider;
        this.initVars();
        this.starList = displayLists = GLAllocation.func_74526_a((int)3);
        this.glSkyList = displayLists + 1;
        this.glSkyList2 = displayLists + 2;
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starList, (int)4864);
        this.prepareStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte2 = 64;
        int i = 6;
        float f = 16.0f;
        for (int j = -384; j <= 384; j += 64) {
            for (int l = -384; l <= 384; l += 64) {
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(l + 0));
                tessellator.func_78377_a((double)(j + 64), (double)f, (double)(l + 0));
                tessellator.func_78377_a((double)(j + 64), (double)f, (double)(l + 64));
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(l + 64));
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.func_78382_b();
        for (int k = -384; k <= 384; k += 64) {
            for (int i1 = -384; i1 <= 384; i1 += 64) {
                tessellator.func_78377_a((double)(k + 64), (double)f, (double)(i1 + 0));
                tessellator.func_78377_a((double)(k + 0), (double)f, (double)(i1 + 0));
                tessellator.func_78377_a((double)(k + 0), (double)f, (double)(i1 + 64));
                tessellator.func_78377_a((double)(k + 64), (double)f, (double)(i1 + 64));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    protected void checkAsteroidRendering(CelestialBody body) {
        if (AmunRa.config.isAsteroidBelt(body)) {
            long seed = (long)body.getName().hashCode() ^ 0x826A1DL;
            this.initAsteroidRenderList(seed);
            this.isAsteroidBelt = true;
            this.hasHorizon = false;
            planetAxisAngle = -90.0f;
            this.isAsteroidBeltMoon = body instanceof Moon;
            if (this.isAsteroidBeltMoon) {
                this.rType = RenderType.RINGS;
            }
        } else {
            this.isAsteroidBelt = false;
            this.clearAsteroidRenderList();
            planetAxisAngle = -19.0f;
        }
    }

    protected void initAsteroidRenderList(long seed) {
        if (this.asteroidTextures == null) {
            this.asteroidTextures = AmunRa.instance.getPossibleAsteroidTextures();
        }
        int numIcons = this.asteroidTextures.size();
        this.asteroidList = GLAllocation.func_74526_a((int)numIcons);
        Random rand = new Random(seed);
        for (int listIndex = 0; listIndex < numIcons; ++listIndex) {
            GL11.glPushMatrix();
            GL11.glNewList((int)(this.asteroidList + listIndex), (int)4864);
            Tessellator tess = Tessellator.field_78398_a;
            int numObjects = (int)(rand.nextFloat() * (float)AmunRa.config.numAsteroids / (float)numIcons);
            tess.func_78382_b();
            for (int starIndex = 0; starIndex < numObjects; ++starIndex) {
                double randX = rand.nextFloat() * 2.0f - 1.0f;
                double randY = rand.nextFloat() * 2.0f - 1.0f;
                double randZ = rand.nextFloat() * 2.0f - 1.0f;
                double size = 0.15f + rand.nextFloat() * 4.0f;
                double sqDistance = randX * randX + randY * randY + randZ * randZ;
                if (!(sqDistance < 1.0) || !(sqDistance > 0.01)) continue;
                sqDistance = 1.0 / Math.sqrt(sqDistance);
                double newX = (randX *= sqDistance) * 100.0;
                double newY = (randY *= sqDistance) * 100.0;
                double newZ = (randZ *= sqDistance) * 100.0;
                double atanXZ = Math.atan2(randX, randZ);
                double xLength = Math.sin(atanXZ);
                double zLength = Math.cos(atanXZ);
                double atanPlaneY = Math.atan2(Math.sqrt(randX * randX + randZ * randZ), randY);
                double yLength = Math.sin(atanPlaneY);
                double planarLength = Math.cos(atanPlaneY);
                double rotationMaybe = rand.nextDouble() * Math.PI * 2.0;
                double rotationSin = Math.sin(rotationMaybe);
                double rotationCos = Math.cos(rotationMaybe);
                double color = 0.9;
                GL11.glColor4d((double)0.9, (double)0.9, (double)0.9, (double)1.0);
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    double zero = 0.0;
                    double indexBasedOffset1 = (double)((vertexIndex & 2) - 1) * size;
                    double indexBasedOffset2 = (double)((vertexIndex + 1 & 2) - 1) * size;
                    double var47 = indexBasedOffset1 * rotationCos - indexBasedOffset2 * rotationSin;
                    double var49 = indexBasedOffset2 * rotationCos + indexBasedOffset1 * rotationSin;
                    double vertexY = var47 * yLength + 0.0 * planarLength;
                    double var55 = 0.0 * yLength - var47 * planarLength;
                    double vertexX = var55 * xLength - var49 * zLength;
                    double vertexZ = var49 * xLength + var55 * zLength;
                    double u = (double)(vertexIndex + 1 & 2) / 2.0;
                    double v = (double)(vertexIndex & 2) / 2.0;
                    tess.func_78374_a(newX + vertexX, newY + vertexY, newZ + vertexZ, u, v);
                }
            }
            tess.func_78381_a();
            GL11.glEndList();
        }
        GL11.glPopMatrix();
    }

    protected void clearAsteroidRenderList() {
        if (this.isAsteroidBelt) {
            GLAllocation.func_74523_b((int)this.asteroidList);
        }
    }

    protected void initVars() {
        this.sunSize = 2.0f * this.worldProvider.getSolarSize();
        if (this.curBody instanceof Planet) {
            this.rType = RenderType.PLANET;
            this.curBodyPlanet = this.curBody;
            this.curSystem = ((Planet)this.curBody).getParentSolarSystem();
        } else if (this.curBody instanceof Moon) {
            this.rType = RenderType.MOON;
            this.curBodyPlanet = ((Moon)this.curBody).getParentPlanet();
            this.curSystem = ((Moon)this.curBody).getParentPlanet().getParentSolarSystem();
        } else if (this.curBody instanceof Star) {
            this.rType = RenderType.STAR;
            this.curSystem = ((Star)this.curBody).getParentSolarSystem();
        }
        this.checkAsteroidRendering(this.curBody);
        this.hasAtmosphere = this.curBody.atmosphere.size() > 0;
        this.curBodyDistance = this.curBodyPlanet.getRelativeDistanceFromCenter().unScaledDistance;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)32826);
        this.planetSkyColor = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        float skyR = (float)this.planetSkyColor.field_72450_a;
        float skyG = (float)this.planetSkyColor.field_72448_b;
        float skyB = (float)this.planetSkyColor.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float f4 = (skyR * 30.0f + skyG * 59.0f + skyB * 11.0f) / 100.0f;
            float f5 = (skyR * 30.0f + skyG * 70.0f) / 100.0f;
            float redIthink = (skyR * 30.0f + skyB * 70.0f) / 100.0f;
            skyR = f4;
            skyG = f5;
            skyB = redIthink;
        }
        GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        Tessellator tessellator1 = Tessellator.field_78398_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float curBrightness = world.func_72880_h(partialTicks);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.currentCelestialAngle = this.getCelestialAngle(world, partialTicks);
        if (this.isAsteroidBelt && this.isAsteroidBeltMoon) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glRotatef((float)(this.currentCelestialAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)planetAxisAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderStars(curBrightness);
        curBrightness = 1.0f - curBrightness;
        GL11.glPopMatrix();
        if (this.isAsteroidBelt) {
            this.renderAsteroids();
        }
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glPushMatrix();
        float someXoffset = 0.0f;
        float someYoffset = 0.0f;
        float someZoffset = 0.0f;
        GL11.glTranslatef((float)someXoffset, (float)someYoffset, (float)someZoffset);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.isAsteroidBelt && this.isAsteroidBeltMoon) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glRotatef((float)(this.currentCelestialAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.hasAtmosphere) {
            GL11.glEnable((int)2912);
            this.renderSystem(partialTicks, world, tessellator1, mc);
            GL11.glDisable((int)2912);
        } else {
            this.renderSystem(partialTicks, world, tessellator1, mc);
        }
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double playerOverHorizonLevel = mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b - world.func_72919_O();
        if (this.hasHorizon) {
            if (playerOverHorizonLevel < 0.0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
                GL11.glCallList((int)this.glSkyList2);
                GL11.glPopMatrix();
                someYoffset = 1.0f;
                someZoffset = -((float)(playerOverHorizonLevel + 65.0));
                float someOtherY = -someYoffset;
                tessellator1.func_78382_b();
                tessellator1.func_78384_a(0, 255);
                tessellator1.func_78377_a((double)(-someYoffset), (double)someZoffset, (double)someYoffset);
                tessellator1.func_78377_a((double)someYoffset, (double)someZoffset, (double)someYoffset);
                tessellator1.func_78377_a((double)someYoffset, (double)someOtherY, (double)someYoffset);
                tessellator1.func_78377_a((double)(-someYoffset), (double)someOtherY, (double)someYoffset);
                tessellator1.func_78377_a((double)(-someYoffset), (double)someOtherY, (double)(-someYoffset));
                tessellator1.func_78377_a((double)someYoffset, (double)someOtherY, (double)(-someYoffset));
                tessellator1.func_78377_a((double)someYoffset, (double)someZoffset, (double)(-someYoffset));
                tessellator1.func_78377_a((double)(-someYoffset), (double)someZoffset, (double)(-someYoffset));
                tessellator1.func_78377_a((double)someYoffset, (double)someOtherY, (double)(-someYoffset));
                tessellator1.func_78377_a((double)someYoffset, (double)someOtherY, (double)someYoffset);
                tessellator1.func_78377_a((double)someYoffset, (double)someZoffset, (double)someYoffset);
                tessellator1.func_78377_a((double)someYoffset, (double)someZoffset, (double)(-someYoffset));
                tessellator1.func_78377_a((double)(-someYoffset), (double)someZoffset, (double)(-someYoffset));
                tessellator1.func_78377_a((double)(-someYoffset), (double)someZoffset, (double)someYoffset);
                tessellator1.func_78377_a((double)(-someYoffset), (double)someOtherY, (double)someYoffset);
                tessellator1.func_78377_a((double)(-someYoffset), (double)someOtherY, (double)(-someYoffset));
                tessellator1.func_78377_a((double)(-someYoffset), (double)someOtherY, (double)(-someYoffset));
                tessellator1.func_78377_a((double)(-someYoffset), (double)someOtherY, (double)someYoffset);
                tessellator1.func_78377_a((double)someYoffset, (double)someOtherY, (double)someYoffset);
                tessellator1.func_78377_a((double)someYoffset, (double)someOtherY, (double)(-someYoffset));
                tessellator1.func_78381_a();
            }
            if (world.field_73011_w.func_76561_g()) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor3f((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f));
            } else {
                GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(-((float)(playerOverHorizonLevel - 16.0))), (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glDisable((int)2912);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)true);
    }

    public float getCelestialAngle(WorldClient world, float partialTicks) {
        if (this.isAsteroidBelt && !this.isAsteroidBeltMoon) {
            return 0.0f;
        }
        return world.func_72826_c(partialTicks);
    }

    protected void renderAsteroids() {
        GL11.glPushMatrix();
        int numIcons = this.asteroidTextures.size();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < numIcons; ++i) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.asteroidTextures.get(i));
            GL11.glCallList((int)(this.asteroidList + i));
        }
        GL11.glPopMatrix();
    }

    protected void renderStars(float curBrightness) {
        if (this.hasAtmosphere) {
            if (curBrightness > 0.0f) {
                GL11.glColor4f((float)curBrightness, (float)curBrightness, (float)curBrightness, (float)curBrightness);
                GL11.glCallList((int)this.starList);
            }
        } else {
            GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
            GL11.glCallList((int)this.starList);
        }
    }

    protected BodyRenderTask renderSiblingBody(CelestialBody body, double curBodyOrbitalAngle, long curWorldTime, float partialTicks, double timeFactor, double distanceToParent) {
        double distance;
        float dist = body.getRelativeDistanceFromCenter().unScaledDistance;
        double curOrbitalAngle = this.getOrbitalAngle(body.getRelativeOrbitTime(), body.getPhaseShift(), curWorldTime, partialTicks, timeFactor);
        double innerAngle = SkyProviderDynamic.fixAngle(curOrbitalAngle - curBodyOrbitalAngle);
        double distanceToPlanet = this.getDistanceToBody(innerAngle, distanceToParent, dist);
        double projectedAngle = this.projectAngle(innerAngle, dist, distanceToPlanet, distanceToParent);
        double size = body.getRelativeSize();
        if (body instanceof Planet) {
            distance = AstronomyHelper.isStar(body) ? size / distanceToPlanet / 4.0 * this.siblingStarFactor : size / distanceToPlanet / 4.0 * this.siblingPlanetFactor;
        } else {
            if (size > 0.6) {
                size = 0.6;
            }
            double d = size / distanceToPlanet;
            Objects.requireNonNull(this);
            distance = d * 80.0;
        }
        return new BodyRenderTask(body, projectedAngle, distanceToPlanet, distance, innerAngle);
    }

    protected void renderSiblingMoons(double curOrbitalAngle, long curWorldTime, float partialTicks) {
        double distanceToParent = this.curBody.getRelativeDistanceFromCenter().unScaledDistance;
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            BodyRenderTask task;
            if (moon.getParentPlanet() == null || !moon.getParentPlanet().equals((Object)this.curBodyPlanet) || moon.equals((Object)this.curBody) || this.excludeBodyFromRendering((CelestialBody)moon) || AmunRa.config.bodiesNoRender.contains(moon.getName()) || (task = this.renderSiblingBody((CelestialBody)moon, curOrbitalAngle, curWorldTime, partialTicks, 192000.0, distanceToParent)) == null) continue;
            this.nearBodiesToRender.add(task);
        }
    }

    protected void renderSiblingPlanets(double curBodyOrbitalAngle, long curWorldTime, float partialTicks) {
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            BodyRenderTask task;
            if (planet.getParentSolarSystem() != this.curSystem || planet.equals((Object)this.curBodyPlanet) || AmunRa.config.bodiesNoRender.contains(planet.getName()) || (task = this.renderSiblingBody((CelestialBody)planet, curBodyOrbitalAngle, curWorldTime, partialTicks, 8640000.0, this.curBodyDistance)) == null) continue;
            this.farBodiesToRender.add(task);
        }
    }

    protected void renderChildPlanets(long curWorldTime, float partialTicks) {
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (planet.getParentSolarSystem() != this.curSystem || planet.equals((Object)this.curBodyPlanet) || AmunRa.config.bodiesNoRender.contains(planet.getName())) continue;
            double zIndex = planet.getRelativeDistanceFromCenter().unScaledDistance;
            double curOrbitalAngle = this.getOrbitalAngle(planet.getRelativeOrbitTime(), planet.getPhaseShift(), curWorldTime, partialTicks, 8640000.0);
            double scale = (double)planet.getRelativeSize() / zIndex / 4.0 * this.childPlanetFactor;
            this.farBodiesToRender.add(new BodyRenderTask((CelestialBody)planet, curOrbitalAngle, zIndex, scale, 0.0));
        }
    }

    protected void renderChildMoons(long curWorldTime, float partialTicks) {
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (moon.getParentPlanet() == null || !moon.getParentPlanet().equals((Object)this.curBodyPlanet) || AmunRa.config.bodiesNoRender.contains(moon.getName())) continue;
            double curOrbitalAngle = this.getOrbitalAngle(moon.getRelativeOrbitTime(), moon.getPhaseShift(), curWorldTime, partialTicks, 192000.0);
            double zIndex = moon.getRelativeDistanceFromCenter().unScaledDistance / 20.0f;
            double moonSize = moon.getRelativeSize();
            if (moonSize > 0.6) {
                moonSize = 0.6;
            }
            double distance = moonSize / (double)moon.getRelativeDistanceFromCenter().unScaledDistance * this.childMoonFactor;
            this.nearBodiesToRender.add(new BodyRenderTask((CelestialBody)moon, curOrbitalAngle, zIndex, distance, Math.PI - curOrbitalAngle));
        }
    }

    protected boolean excludeBodyFromRendering(CelestialBody body) {
        return false;
    }

    protected void renderParentPlanet(double curOrbitalAngle) {
        double distanceToParent = this.curBody.getRelativeDistanceFromCenter().unScaledDistance;
        double mainBodyOrbitalAngle = Math.PI - curOrbitalAngle;
        double zIndex = (float)(20.0 / distanceToParent);
        double d = (float)((double)this.curBodyPlanet.getRelativeSize() / distanceToParent);
        Objects.requireNonNull(this);
        double distance = d * 80.0;
        this.nearBodiesToRender.add(new BodyRenderTask(this.curBodyPlanet, mainBodyOrbitalAngle, zIndex, distance, curOrbitalAngle));
    }

    protected void renderRingsParentPlanet(CelestialBody bodyToRender) {
        double distanceToParent = this.curBody.getRelativeDistanceFromCenter().unScaledDistance;
        double zIndex = (float)(20.0 / distanceToParent);
        double d = (float)((double)this.curBodyPlanet.getRelativeSize() / distanceToParent);
        Objects.requireNonNull(this);
        double distance = d * 80.0;
        BodyRenderTask task = new BodyRenderTask(bodyToRender, (double)(-this.currentCelestialAngle) * (Math.PI * 2) + Math.PI, zIndex, distance, (double)this.currentCelestialAngle * (Math.PI * 2));
        this.nearBodiesToRender.add(task);
    }

    protected void renderMainStar() {
        double distance = (double)(this.sunSize / this.curBodyDistance) * this.parentSunFactor;
        this.farBodiesToRender.add(new BodyRenderTask((CelestialBody)this.curSystem.getMainStar(), 0.0, this.curBodyDistance, distance, 0.0));
    }

    protected double prepareSystemForRender(long curWorldTime, float partialTicks) {
        double curOrbitalAngle = 0.0;
        switch (this.rType) {
            case STAR: {
                this.renderChildPlanets(curWorldTime, partialTicks);
                break;
            }
            case PLANET: {
                curOrbitalAngle = this.getOrbitalAngle(this.curBodyPlanet.getRelativeDistanceFromCenter().unScaledDistance, this.curBodyPlanet.getPhaseShift(), curWorldTime, partialTicks, 8640000.0);
                this.renderMainStar();
                this.renderSiblingPlanets(curOrbitalAngle, curWorldTime, partialTicks);
                this.renderChildMoons(curWorldTime, partialTicks);
                break;
            }
            case MOON: {
                curOrbitalAngle = this.getOrbitalAngle(this.curBody.getRelativeOrbitTime(), this.curBody.getPhaseShift(), curWorldTime, partialTicks, 192000.0);
                this.renderMainStar();
                this.renderParentPlanet(curOrbitalAngle);
                this.renderSiblingMoons(curOrbitalAngle, curWorldTime, partialTicks);
                break;
            }
            case RINGS: {
                curOrbitalAngle = this.getOrbitalAngle(this.curBodyPlanet.getRelativeDistanceFromCenter().unScaledDistance, this.curBodyPlanet.getPhaseShift(), curWorldTime, partialTicks, 8640000.0);
                this.renderMainStar();
                this.renderRingsParentPlanet(this.curBodyPlanet);
                this.renderSiblingMoons(curOrbitalAngle, curWorldTime, partialTicks);
            }
        }
        return curOrbitalAngle;
    }

    protected void renderSystem(float partialTicks, WorldClient world, Tessellator tess, Minecraft mc) {
        this.farBodiesToRender.clear();
        this.nearBodiesToRender.clear();
        GL11.glDisable((int)3553);
        long curWorldTime = world.func_72820_D();
        this.prepareSystemForRender(curWorldTime, partialTicks);
        Collections.sort(this.farBodiesToRender);
        Collections.sort(this.nearBodiesToRender);
        GL11.glPushMatrix();
        if (this.isAsteroidBelt) {
            if (!this.isAsteroidBeltMoon) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GL11.glPushMatrix();
        if (!this.isAsteroidBelt) {
            GL11.glRotatef((float)planetAxisAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glEnable((int)3042);
        for (BodyRenderTask task : this.farBodiesToRender) {
            this.renderPlanetByAngle(tess, task.body, task.angle, task.zIndex + 120.0, task.scale, task.phaseAngle);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (!this.isAsteroidBelt) {
            GL11.glRotatef((float)moonAxisAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        for (BodyRenderTask task : this.nearBodiesToRender) {
            this.renderPlanetByAngle(tess, task.body, task.angle, task.zIndex + 100.0, task.scale, task.phaseAngle);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected double getOrbitalAngle(double relOrbitTime, double phaseShift, long worldTime, double partialTicks, double orbitFactor) {
        double curYearLength = relOrbitTime * orbitFactor;
        long j = worldTime % (long)curYearLength;
        double orbitPos = ((double)j + partialTicks) / curYearLength;
        return orbitPos * (Math.PI * 2) + phaseShift;
    }

    private double getDistanceToBody(double innerAngle, double bodyDistance, double otherBodyDistance) {
        return Math.sqrt(Math.pow(otherBodyDistance, 2.0) + Math.pow(bodyDistance, 2.0) - 2.0 * otherBodyDistance * bodyDistance * Math.cos(innerAngle));
    }

    private double projectAngle(double innerAngle, double otherBodyDistance, double distFromThisToOtherBody, double curBodyDistance) {
        double sinBeta = Math.sin(innerAngle);
        double angleAroundCurBody = Math.asin(otherBodyDistance * sinBeta / distFromThisToOtherBody);
        if (curBodyDistance > otherBodyDistance) {
            return angleAroundCurBody;
        }
        double delta = Math.asin(sinBeta / distFromThisToOtherBody * curBodyDistance);
        double angleSum = innerAngle + delta + angleAroundCurBody;
        if (Math.abs(Math.abs(angleSum) / Math.PI - 1.0) < 0.001) {
            return angleAroundCurBody;
        }
        return Math.PI - angleAroundCurBody;
    }

    protected void renderSunAura(Tessellator tessellator1, Vector3 color, double size, double brightness, double zIndex) {
        GL11.glPushMatrix();
        GL11.glShadeModel((int)7425);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        zIndex += (double)0.01f;
        float maxOpacity = (float)(brightness / 18.0);
        if (maxOpacity > 1.0f) {
            maxOpacity = 1.0f;
        }
        tessellator1.func_78371_b(6);
        tessellator1.func_78369_a((float)color.x, (float)color.y, (float)color.z, maxOpacity);
        tessellator1.func_78377_a(0.0, zIndex, 0.0);
        tessellator1.func_78369_a((float)color.x, (float)color.y, (float)color.z, 0.0f);
        tessellator1.func_78377_a(-size, zIndex, -size);
        tessellator1.func_78377_a(0.0, zIndex, -size * 1.5);
        tessellator1.func_78377_a(size, zIndex, -size);
        tessellator1.func_78377_a(size * 1.5, zIndex, 0.0);
        tessellator1.func_78377_a(size, zIndex, size);
        tessellator1.func_78377_a(0.0, zIndex, size * 1.5);
        tessellator1.func_78377_a(-size, zIndex, size);
        tessellator1.func_78377_a(-size * 1.5, zIndex, 0.0);
        tessellator1.func_78377_a(-size, zIndex, -size);
        tessellator1.func_78381_a();
        GL11.glPopMatrix();
    }

    protected void renderRing(Tessellator tessellator1, RingsRenderInfo ringTexture, double angle, double zIndex, double scale, double phaseAngle) {
        double startOffsetScaled;
        double textureHeight;
        double textureWidth;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(ringTexture.textureLocation);
        zIndex += 0.1;
        if (ringTexture.textureSize == null) {
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            ringTexture.setTextureSize(width, height);
        }
        double heightOffset = 0.0;
        double widthOffset = 0.0;
        int gapSize = ringTexture.gapEnd - ringTexture.gapStart;
        double scalingFactor = 2.0 * scale / (double)gapSize;
        if (ringTexture.textureSize.x >= ringTexture.textureSize.y) {
            if (ringTexture.textureSize.x <= gapSize) {
                return;
            }
            textureWidth = scalingFactor * (double)ringTexture.textureSize.x;
            textureHeight = (double)ringTexture.textureSize.y / (double)ringTexture.textureSize.x * textureWidth;
            startOffsetScaled = (double)ringTexture.gapStart * scalingFactor;
            widthOffset = startOffsetScaled - (textureWidth - 2.0 * scale) / 2.0;
        } else {
            if (ringTexture.textureSize.y <= gapSize) {
                return;
            }
            textureHeight = scalingFactor * (double)ringTexture.textureSize.y;
            textureWidth = (double)ringTexture.textureSize.x / (double)ringTexture.textureSize.y * textureHeight;
            startOffsetScaled = (double)ringTexture.gapStart * scalingFactor;
            heightOffset = startOffsetScaled - (textureHeight - 2.0 * scale) / 2.0;
        }
        double widthHalf = textureWidth / 2.0;
        double heightHalf = textureHeight / 2.0;
        tessellator1.func_78382_b();
        tessellator1.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator1.func_78374_a(-heightHalf + heightOffset, zIndex, widthHalf + widthOffset, 0.0, 0.0);
        tessellator1.func_78374_a(-heightHalf + heightOffset, zIndex, -widthHalf + widthOffset, 1.0, 0.0);
        tessellator1.func_78374_a(heightHalf + heightOffset, zIndex, -widthHalf + widthOffset, 1.0, 1.0);
        tessellator1.func_78374_a(heightHalf + heightOffset, zIndex, widthHalf + widthOffset, 0.0, 1.0);
        tessellator1.func_78381_a();
    }

    protected void renderPlanetByAngle(Tessellator tessellator1, CelestialBody body, double angle, double zIndex, double scale, double phaseAngle) {
        RingsRenderInfo ringTex;
        if (scale < 0.13) {
            return;
        }
        boolean usePhaseOverlay = true;
        GL11.glPushMatrix();
        double overlayScale = scale + 0.001;
        GL11.glRotatef((float)((float)(angle / Math.PI * 180.0)), (float)1.0f, (float)0.0f, (float)0.0f);
        Vector3 color = AmunRa.config.sunColorMap.get(body.getName());
        if (body instanceof Star && color == null) {
            color = new Vector3(1.0, (double)0.4f, (double)0.1f);
        }
        if (color != null) {
            this.renderSunAura(tessellator1, color, scale * 5.0, scale, zIndex);
            usePhaseOverlay = false;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(body.getBodyIcon());
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        tessellator1.func_78382_b();
        tessellator1.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator1.func_78374_a(-scale, zIndex, -scale, 0.0, 0.0);
        tessellator1.func_78374_a(scale, zIndex, -scale, 1.0, 0.0);
        tessellator1.func_78374_a(scale, zIndex, scale, 1.0, 1.0);
        tessellator1.func_78374_a(-scale, zIndex, scale, 0.0, 1.0);
        tessellator1.func_78381_a();
        if (usePhaseOverlay) {
            this.drawPhaseOverlay(phaseAngle, body, scale + 0.01, tessellator1, zIndex);
        }
        if ((ringTex = AmunRa.config.ringMap.get(body.getName())) != null) {
            this.renderRing(tessellator1, ringTex, angle, zIndex, overlayScale, phaseAngle);
        }
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
    }

    private void drawPhaseOverlay(double phaseAngle, CelestialBody body, double overlayScale, Tessellator tessellator1, double zIndex) {
        double startOffset = 0.0;
        double stopOffset = 0.0;
        boolean canBeBehindTheSun = false;
        if (body instanceof Planet && !body.equals((Object)this.curBodyPlanet) && body.getRelativeDistanceFromCenter().unScaledDistance > this.curBodyPlanet.getRelativeDistanceFromCenter().unScaledDistance) {
            canBeBehindTheSun = true;
        }
        if (!canBeBehindTheSun || phaseAngle < 1.5707963267948966 || phaseAngle > 4.71238898038469) {
            if (phaseAngle < Math.PI) {
                startOffset = overlayScale + (1.0 - phaseAngle / 1.5707963267948966) * overlayScale;
            } else {
                stopOffset = overlayScale + (1.0 - (Math.PI * 2 - phaseAngle) / 1.5707963267948966) * overlayScale;
            }
        } else if (phaseAngle < Math.PI) {
            startOffset = phaseAngle / Math.PI * overlayScale * 2.0;
        } else {
            stopOffset = (Math.PI * 2 - phaseAngle) / Math.PI * overlayScale * 2.0;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.85f);
        tessellator1.func_78382_b();
        double length = 2.0 * overlayScale;
        double texStartOffset = startOffset / length;
        double texStopOffset = (length - stopOffset) / length;
        tessellator1.func_78374_a(-overlayScale, zIndex + (double)0.01f, -overlayScale + startOffset, 0.0, texStartOffset);
        tessellator1.func_78374_a(overlayScale, zIndex + (double)0.01f, -overlayScale + startOffset, 1.0, texStartOffset);
        tessellator1.func_78374_a(overlayScale, zIndex + (double)0.01f, overlayScale - stopOffset, 1.0, texStopOffset);
        tessellator1.func_78374_a(-overlayScale, zIndex + (double)0.01f, overlayScale - stopOffset, 0.0, texStopOffset);
        tessellator1.func_78381_a();
    }

    private void prepareStars() {
        Random rand = new Random(10842L);
        Tessellator var2 = Tessellator.field_78398_a;
        var2.func_78382_b();
        for (int starIndex = 0; starIndex < 6000; ++starIndex) {
            double var4 = rand.nextFloat() * 2.0f - 1.0f;
            double var6 = rand.nextFloat() * 2.0f - 1.0f;
            double var8 = rand.nextFloat() * 2.0f - 1.0f;
            double var10 = 0.15f + rand.nextFloat() * 0.1f;
            double var12 = var4 * var4 + var6 * var6 + var8 * var8;
            if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
            var12 = 1.0 / Math.sqrt(var12);
            double var14 = (var4 *= var12) * 100.0;
            double var16 = (var6 *= var12) * 100.0;
            double var18 = (var8 *= var12) * 100.0;
            double var20 = Math.atan2(var4, var8);
            double var22 = Math.sin(var20);
            double var24 = Math.cos(var20);
            double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
            double var28 = Math.sin(var26);
            double var30 = Math.cos(var26);
            double var32 = rand.nextDouble() * Math.PI * 2.0;
            double var34 = Math.sin(var32);
            double var36 = Math.cos(var32);
            for (int var38 = 0; var38 < 4; ++var38) {
                double var39 = 0.0;
                double var41 = (double)((var38 & 2) - 1) * var10;
                double var43 = (double)((var38 + 1 & 2) - 1) * var10;
                double var47 = var41 * var36 - var43 * var34;
                double var49 = var43 * var36 + var41 * var34;
                double var53 = var47 * var28 + 0.0 * var30;
                double var55 = 0.0 * var28 - var47 * var30;
                double var57 = var55 * var22 - var49 * var24;
                double var61 = var49 * var22 + var55 * var24;
                var2.func_78377_a(var14 + var57, var16 + var53, var18 + var61);
            }
        }
        var2.func_78381_a();
    }

    public float getSkyBrightness(float par1) {
        float var2 = FMLClientHandler.instance().getClient().field_71441_e.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76126_a((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 1.0f;
    }

    protected static enum RenderType {
        STAR,
        PLANET,
        MOON,
        RINGS;

    }

    public class BodyRenderTask
    implements Comparable<BodyRenderTask> {
        public double angle;
        public double zIndex;
        public double scale;
        public double phaseAngle;
        public CelestialBody body;

        public BodyRenderTask(CelestialBody body, double angle, double zIndex, double scale, double phaseAngle) {
            this.body = body;
            this.angle = SkyProviderDynamic.fixAngle(angle);
            this.zIndex = zIndex;
            this.scale = scale;
            this.phaseAngle = SkyProviderDynamic.fixAngle(phaseAngle);
        }

        @Override
        public int compareTo(BodyRenderTask other) {
            if (this.zIndex > other.zIndex) {
                return -1;
            }
            if (this.zIndex < other.zIndex) {
                return 1;
            }
            return 0;
        }
    }
}

