/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.pyramid;

import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import de.katzenpapst.amunra.world.mapgen.StructureGenerator;
import de.katzenpapst.amunra.world.mapgen.pyramid.Pyramid;
import de.katzenpapst.amunra.world.mapgen.pyramid.PyramidRoom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.util.MathHelper;

public class PyramidGenerator
extends StructureGenerator {
    protected BlockMetaPair wallMaterial = ARBlocks.blockAluCrate;
    protected BlockMetaPair floorMaterial = ARBlocks.blockSmoothBasalt;
    protected BlockMetaPair fillMaterial = ARBlocks.blockBasaltBrick;
    protected final List<StructureGenerator.SubComponentData> components = new ArrayList<StructureGenerator.SubComponentData>();
    protected final List<StructureGenerator.SubComponentData> potentialMainRooms = new ArrayList<StructureGenerator.SubComponentData>();

    @Override
    protected boolean canGenerateHere(int chunkX, int chunkZ, Random rand) {
        int rangeShift = 5;
        int range = 32;
        int superchunkX = chunkX >> 5;
        int superchunkZ = chunkZ >> 5;
        int chunkStartX = superchunkX << 5;
        int chunkStartZ = superchunkZ << 5;
        int chunkEndX = chunkStartX + 32 - 1;
        int chunkEndZ = chunkStartZ + 32 - 1;
        this.rand.setSeed(this.worldObj.func_72905_C() ^ this.getSalt() ^ (long)superchunkX ^ (long)superchunkZ);
        int actualVillageX = MathHelper.func_76136_a((Random)this.rand, (int)chunkStartX, (int)chunkEndX);
        int actualVillageZ = MathHelper.func_76136_a((Random)this.rand, (int)chunkStartZ, (int)chunkEndZ);
        return chunkX == actualVillageX && chunkZ == actualVillageZ;
    }

    public void addComponentType(Class<? extends PyramidRoom> clazz, float probability) {
        this.addComponentType(clazz, probability, 0, 0);
    }

    public void addComponentType(Class<? extends PyramidRoom> clazz, float probability, int minAmount, int maxAmount) {
        this.components.add(new StructureGenerator.SubComponentData(clazz, probability, minAmount, maxAmount));
    }

    public void addMainRoomType(Class<? extends PyramidRoom> clazz, float probability) {
        this.potentialMainRooms.add(new StructureGenerator.SubComponentData(clazz, probability, 0, 0));
    }

    @Override
    protected BaseStructureStart createNewStructure(int xChunkCoord, int zChunkCoord) {
        Pyramid p = new Pyramid(this.worldObj, xChunkCoord, zChunkCoord, this.rand);
        p.setFillMaterial(this.fillMaterial);
        p.setFloorMaterial(this.floorMaterial);
        p.setWallMaterial(this.wallMaterial);
        Random rand4structure = new Random(this.worldObj.func_72905_C() ^ this.getSalt() ^ (long)xChunkCoord ^ (long)zChunkCoord);
        List<BaseStructureComponent> compList = this.generateSubComponents(this.components, rand4structure, 12);
        p.setSmallRooms(compList);
        p.setMainRoom((PyramidRoom)this.generateOneComponent(this.potentialMainRooms, rand4structure));
        return p;
    }

    @Override
    public String getName() {
        return "Pyramid";
    }

    @Override
    protected long getSalt() {
        return 549865610521L;
    }

    public BlockMetaPair getWallMaterial() {
        return this.wallMaterial;
    }

    public void setWallMaterial(BlockMetaPair wallMaterial) {
        this.wallMaterial = wallMaterial;
    }

    public BlockMetaPair getFloorMaterial() {
        return this.floorMaterial;
    }

    public void setFloorMaterial(BlockMetaPair floorMaterial) {
        this.floorMaterial = floorMaterial;
    }

    public BlockMetaPair getFillMaterial() {
        return this.fillMaterial;
    }

    public void setFillMaterial(BlockMetaPair fillMaterial) {
        this.fillMaterial = fillMaterial;
    }
}

