/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import mantle.blocks.BlockUtils;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.inventory.DrawbridgeContainer;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;
import tmechworks.lib.player.FakePlayerLogic;

public class DrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic,
IDrawbridgeLogicBase {
    boolean active;
    boolean working;
    int ticks;
    byte extension;
    byte maxExtension = (byte)15;
    byte direction;
    byte placementDirection = (byte)4;
    FakePlayerLogic fakePlayer;
    ItemStack bufferStack = null;

    public DrawbridgeLogic() {
        super(2);
    }

    public void func_145843_s() {
        this.field_145846_f = true;
        this.fakePlayer = null;
    }

    private void initFakePlayer() {
        if (this.fakePlayer == null && !this.func_145837_r()) {
            this.fakePlayer = new FakePlayerLogic(new GameProfile(null, "Player.Drawbridge"), (TileEntity)this);
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public boolean canDropInventorySlot(int slot) {
        return false;
    }

    public void setMaximumExtension(byte length) {
        this.maxExtension = length;
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void setPlacementDirection(byte keycode) {
        this.placementDirection = keycode;
        if (!this.field_145850_b.field_72995_K) {
            this.initFakePlayer();
            this.setFakePlayerRotation();
        }
    }

    private void setFakePlayerRotation() {
        if (this.placementDirection == 4) {
            this.fakePlayer.field_70177_z = 0.0f;
            this.fakePlayer.field_70125_A = 0.0f;
        } else if (this.direction == 0 || this.direction == 1) {
            switch (this.placementDirection) {
                case 0: {
                    this.fakePlayer.field_70177_z = 0.0f;
                    break;
                }
                case 1: {
                    this.fakePlayer.field_70177_z = 90.0f;
                    break;
                }
                case 2: {
                    this.fakePlayer.field_70177_z = 180.0f;
                    break;
                }
                case 3: {
                    this.fakePlayer.field_70177_z = 270.0f;
                }
            }
            this.fakePlayer.field_70125_A = this.direction == 0 ? -90.0f : 90.0f;
        } else if (this.placementDirection == 0) {
            this.fakePlayer.field_70177_z = this.mapDirection() * 90;
            this.fakePlayer.field_70125_A = this.placementDirection == 0 ? 90.0f : -90.0f;
        } else if (this.placementDirection == 2) {
            int face = this.mapDirection() + 2;
            if (face > 3) {
                face -= 4;
            }
            this.fakePlayer.field_70177_z = face * 90;
            this.fakePlayer.field_70125_A = this.placementDirection == 0 ? 90.0f : -90.0f;
        } else {
            this.fakePlayer.field_70125_A = 0.0f;
            int facing = this.mapDirection();
            facing = this.placementDirection == 1 ? ++facing : --facing;
            if (facing >= 4) {
                facing = 0;
            }
            if (facing < 0) {
                facing = 3;
            }
            this.fakePlayer.field_70177_z = facing * 90;
        }
    }

    int mapDirection() {
        if (this.direction == 2) {
            return 0;
        }
        if (this.direction == 5) {
            return 1;
        }
        if (this.direction == 3) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte getPlacementDirection() {
        return this.placementDirection;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new DrawbridgeContainer(inventoryplayer, this);
    }

    protected String getDefaultName() {
        return "tmechworks.drawbridge";
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (slot == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        if (slot == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return stack;
    }

    public void func_145845_h() {
        if (this.working && !this.func_145837_r() && !this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.inventory[0] != null && this.inventory[0].field_77994_a > 0 && this.extension < this.maxExtension) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.field_145851_c;
                        int yPos = this.field_145848_d;
                        int zPos = this.field_145849_e;
                        this.bufferStack = this.inventory[0].func_77946_l();
                        this.bufferStack.field_77994_a = 1;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        if (xPos < -30000000 || zPos < -30000000 || xPos >= 30000000 || zPos >= 30000000 || yPos < 0 || yPos >= 256) {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                            return;
                        }
                        Block block = this.field_145850_b.func_147439_a(xPos, yPos, zPos);
                        if (block == null || block.isAir((IBlockAccess)this.field_145850_b, xPos, yPos, zPos) || block.func_149742_c(this.field_145850_b, xPos, yPos, zPos)) {
                            List list;
                            Block placeBlock;
                            this.initFakePlayer();
                            this.setFakePlayerRotation();
                            Item blockToItem = (Item)TMechworksRegistry.blockToItemMapping.get((Object)Item.func_150891_b((Item)this.bufferStack.func_77973_b()));
                            if (blockToItem == Item.func_150898_a((Block)Blocks.field_150350_a)) {
                                if (Block.func_149634_a((Item)this.inventory[0].func_77973_b()) == null) {
                                    return;
                                }
                                placeBlock = Block.func_149634_a((Item)this.bufferStack.func_77973_b());
                                this.placeBlockAt(this.bufferStack, (EntityPlayer)this.fakePlayer, this.field_145850_b, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.bufferStack.func_77960_j(), placeBlock);
                            } else {
                                placeBlock = Block.func_149634_a((Item)blockToItem);
                                this.placeBlockAt(this.bufferStack, (EntityPlayer)this.fakePlayer, this.field_145850_b, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.bufferStack.func_77960_j(), placeBlock);
                            }
                            this.field_145850_b.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
                            ArrayList pushedObjects = new ArrayList();
                            AxisAlignedBB axisalignedbb = Block.func_149634_a((Item)this.bufferStack.func_77973_b()).func_149668_a(this.field_145850_b, xPos, yPos, zPos);
                            if (axisalignedbb != null && !(list = this.field_145850_b.func_72839_b((Entity)null, axisalignedbb)).isEmpty()) {
                                pushedObjects.addAll(list);
                                for (Entity entity : pushedObjects) {
                                    entity.func_70091_d((double)Facing.field_71586_b[this.direction], (double)Facing.field_71587_c[this.direction], (double)Facing.field_71585_d[this.direction]);
                                }
                                pushedObjects.clear();
                            }
                            this.func_70298_a(0, 1);
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.inventory[0] == null || this.inventory[0].field_77994_a < this.inventory[0].func_77976_d()) && this.extension > 0) {
                    int xPos = this.field_145851_c;
                    int yPos = this.field_145848_d;
                    int zPos = this.field_145849_e;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = this.field_145850_b.func_147439_a(xPos, yPos, zPos);
                    if (block != null) {
                        int meta = this.field_145850_b.func_72805_g(xPos, yPos, zPos);
                        if (this.bufferStack != null && this.validBlock(block) && this.validMetadata(block, meta) && this.validDrawbridge(xPos, yPos, zPos) && !this.hasInventory(xPos, yPos, zPos)) {
                            this.field_145850_b.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.15f + 0.6f);
                            if (this.field_145850_b.func_147449_b(xPos, yPos, zPos, Blocks.field_150350_a)) {
                                if (this.inventory[0] == null) {
                                    this.inventory[0] = this.bufferStack.func_77946_l();
                                } else {
                                    ++this.inventory[0].field_77994_a;
                                }
                            }
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        Item blockItem = stack.func_77973_b();
        metadata = blockItem.func_77647_b(metadata);
        metadata = block.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (blockItem instanceof ItemBlock) {
            return ((ItemBlock)blockItem).placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        }
        if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == block) {
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    boolean validDrawbridge(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        return !(te instanceof IDrawbridgeLogicBase) || !((IDrawbridgeLogicBase)te).hasExtended();
    }

    boolean validBlock(Block block) {
        Block type = TMechworksRegistry.interchangableBlockMapping.get(new ItemStack(block).func_77973_b());
        if (type != Blocks.field_150350_a && type == Block.func_149634_a((Item)this.bufferStack.func_77973_b())) {
            return true;
        }
        Item blockToItem = (Item)TMechworksRegistry.blockToItemMapping.get((Object)new ItemStack(block).func_77973_b());
        if (blockToItem != Item.func_150898_a((Block)Blocks.field_150350_a) && blockToItem == this.bufferStack.func_77973_b()) {
            return true;
        }
        return new ItemStack(block).func_77973_b() == this.bufferStack.func_77973_b();
    }

    boolean validMetadata(Block block, int metadata) {
        return true;
    }

    boolean hasInventory(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        return te != null && (te instanceof IInventory || te instanceof ISidedInventory);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.active = tags.func_74767_n("Active");
        this.working = tags.func_74767_n("Working");
        this.extension = tags.func_74771_c("Extension");
        this.maxExtension = tags.func_74771_c("MaxExtension");
        NBTTagCompound bufferInv = (NBTTagCompound)tags.func_74781_a("BufferInv");
        if (bufferInv != null) {
            this.bufferStack = ItemStack.func_77949_a((NBTTagCompound)bufferInv);
        }
        if (this.bufferStack == null && this.inventory[0] != null) {
            this.bufferStack = this.inventory[0];
        }
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74757_a("Working", this.working);
        tags.func_74774_a("Extension", this.extension);
        tags.func_74774_a("MaxExtension", this.maxExtension);
        if (this.bufferStack != null) {
            NBTTagCompound bufferInv = new NBTTagCompound();
            this.bufferStack.func_77955_b(bufferInv);
            tags.func_74782_a("BufferInv", (NBTBase)bufferInv);
        }
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.placementDirection = tags.func_74771_c("Placement");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74774_a("Placement", this.placementDirection);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_70301_a(0) != null) {
            this.bufferStack = this.func_70301_a(0).func_77946_l();
            this.bufferStack.field_77994_a = 1;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack == null || !(itemstack.func_77973_b() instanceof ItemBlock) || this.hasExtended()) {
            return false;
        }
        if (slot == 1) {
            if (this.inventory[slot] != null || itemstack.field_77994_a > 1) {
                return false;
            }
            Block block = BlockUtils.getBlockFromItemStack((ItemStack)itemstack);
            return block.func_149662_c() && block.func_149686_d();
        }
        if (TMechworksRegistry.isItemDBBlacklisted((ItemBlock)itemstack.func_77973_b())) {
            return false;
        }
        return super.func_94041_b(slot, itemstack);
    }
}

