/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.tools.AbilityHelper;

public class FirestarterLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic {
    boolean active;
    boolean shouldActivate;
    byte direction;

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.shouldActivate = true;
    }

    void setFire() {
        int xPos = this.field_145851_c;
        int yPos = this.field_145848_d;
        int zPos = this.field_145849_e;
        switch (this.direction) {
            case 0: {
                --yPos;
                break;
            }
            case 1: {
                ++yPos;
                break;
            }
            case 2: {
                --zPos;
                break;
            }
            case 3: {
                ++zPos;
                break;
            }
            case 4: {
                --xPos;
                break;
            }
            case 5: {
                ++xPos;
            }
        }
        Block block = this.field_145850_b.func_147439_a(xPos, yPos, zPos);
        if (this.active) {
            if (block == null || WorldHelper.isAirBlock((World)this.field_145850_b, (int)xPos, (int)yPos, (int)zPos)) {
                this.field_145850_b.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "fire.ignite", 1.0f, AbilityHelper.random.nextFloat() * 0.4f + 0.8f);
                this.field_145850_b.func_147449_b(xPos, yPos, zPos, (Block)Blocks.field_150480_ab);
            }
        } else if (block == Blocks.field_150480_ab) {
            this.field_145850_b.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "fire.ignite", 1.0f, AbilityHelper.random.nextFloat() * 0.4f + 0.8f);
            this.field_145850_b.func_147465_d(xPos, yPos, zPos, Blocks.field_150350_a, 0, 3);
            this.shouldActivate = true;
        }
    }

    public void func_145845_h() {
        if (this.shouldActivate) {
            this.shouldActivate = false;
            this.setFire();
        }
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        tags.func_74757_a("Active", this.active);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.active = tags.func_74767_n("Active");
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

