/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.angermod.events;

import com.github.namikon.angermod.AngerMod;
import com.github.namikon.angermod.auxiliary.MinecraftBlock;
import com.github.namikon.angermod.config.AngerModConfig;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;

public class BlockBreakEvent {
    private AngerModConfig _mConfig = null;

    public BlockBreakEvent(AngerModConfig pCfgMan) {
        this._mConfig = pCfgMan;
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent pEvent) {
        if (pEvent.getPlayer() instanceof FakePlayer) {
            return;
        }
        try {
            for (MinecraftBlock tBlock : this._mConfig.BlacklistedBlocks) {
                if (!tBlock.isEqualTo(pEvent)) continue;
                if (pEvent.getPlayer().field_71093_bK == -1) {
                    BlockBreakEvent.aggroZombiePigmenInRange(pEvent.getPlayer(), this._mConfig.PigmenAggrorange);
                    continue;
                }
                if (pEvent.getPlayer().field_71093_bK != 1) continue;
                BlockBreakEvent.aggroEndermenInRange(pEvent.getPlayer(), this._mConfig.EndermanAggrorange);
            }
        }
        catch (Exception e) {
            AngerMod.Logger.warn("BlockBreakEvent.onBreakBlock.Error", (Object)"An error occoured while processing onBreakBlock. Please report");
            AngerMod.Logger.DumpStack("BlockBreakEvent.onBreakBlock.Stack", e);
        }
    }

    public static void aggroEndermenInRange(EntityPlayer player, int range) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        AxisAlignedBB tBoundingBox = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range));
        List nearbyEntities = player.field_70170_p.func_72872_a(EntityEnderman.class, tBoundingBox);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof EntityEnderman)) continue;
            EntityEnderman enderman = (EntityEnderman)entity;
            enderman.func_70784_b((Entity)player);
            enderman.func_70819_e(true);
        }
    }

    public static void aggroZombiePigmenInRange(EntityPlayer player, int range) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range));
        List nearbyEntities = player.field_70170_p.func_72872_a(EntityPigZombie.class, boundingBox);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof EntityPigZombie)) continue;
            EntityPigZombie zombiePigman = (EntityPigZombie)entity;
            zombiePigman.func_70784_b((Entity)player);
            zombiePigman.field_70170_p.func_72956_a((Entity)zombiePigman, "mob.zombiepig.zpighurt", 1.0f, 1.0f);
        }
    }
}

