/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.dropoff;

import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.dropoff.InteractionResult;
import com.cleanroommc.bogosorter.common.dropoff.InventoryData;
import com.cleanroommc.bogosorter.common.dropoff.LocalizationHelper;
import com.cleanroommc.bogosorter.compat.Mods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import serverutils.data.ClaimedChunks;

public class InventoryManager {
    private final EntityPlayerMP player;
    private final World world;

    public InventoryManager(EntityPlayerMP player) {
        this.player = player;
        this.world = player.func_130014_f_();
    }

    EntityPlayerMP getPlayer() {
        return this.player;
    }

    public <T extends TileEntity> List<InventoryData> getNearbyInventories() {
        int minX = (int)(this.player.field_70165_t - (double)BogoSorterConfig.dropOff.dropoffRadius);
        int maxX = (int)(this.player.field_70165_t + (double)BogoSorterConfig.dropOff.dropoffRadius);
        int minY = (int)(this.player.field_70163_u - (double)BogoSorterConfig.dropOff.dropoffRadius);
        int maxY = (int)(this.player.field_70163_u + (double)BogoSorterConfig.dropOff.dropoffRadius);
        int minZ = (int)(this.player.field_70161_v - (double)BogoSorterConfig.dropOff.dropoffRadius);
        int maxZ = (int)(this.player.field_70161_v + (double)BogoSorterConfig.dropOff.dropoffRadius);
        ArrayList<InventoryData> inventoryDataList = new ArrayList<InventoryData>();
        Vec3 lookVec = this.player.func_70040_Z();
        int lookX = (int)Math.signum(lookVec.field_72450_a);
        int lookY = (int)Math.signum(lookVec.field_72448_b);
        int lookZ = (int)Math.signum(lookVec.field_72449_c);
        int[] xOrder = lookX >= 0 ? this.range(minX, maxX + 1) : this.reverseRange(minX, maxX + 1);
        int[] yOrder = lookY >= 0 ? this.range(minY, maxY + 1) : this.reverseRange(minY, maxY + 1);
        int[] zOrder = lookZ >= 0 ? this.range(minZ, maxZ + 1) : this.reverseRange(minZ, maxZ + 1);
        for (int x : xOrder) {
            for (int y : yOrder) {
                for (int z : zOrder) {
                    InventoryData previousInvData;
                    InventoryData currentInvData;
                    TileEntity currentEntity = this.world.func_147438_o(x, y, z);
                    if (currentEntity instanceof IInventory) {
                        if (Mods.ServerUtilities.isLoaded() && ClaimedChunks.blockBlockInteractions((EntityPlayer)this.player, (int)x, (int)y, (int)z, (int)0)) continue;
                        currentInvData = this.getInventoryData(currentEntity);
                    } else {
                        if (!(currentEntity instanceof TileEntityEnderChest) || Mods.ServerUtilities.isLoaded() && ClaimedChunks.blockBlockInteractions((EntityPlayer)this.player, (int)x, (int)y, (int)z, (int)0)) continue;
                        currentInvData = this.getInventoryData((TileEntityEnderChest)currentEntity);
                    }
                    int listSize = inventoryDataList.size();
                    if (listSize > 0 && (previousInvData = (InventoryData)inventoryDataList.get(listSize - 1)).getEntities().contains(currentEntity) || !currentInvData.getInventory().func_70300_a((EntityPlayer)this.player) || !this.isInventoryValid(currentInvData)) continue;
                    inventoryDataList.add(currentInvData);
                }
            }
        }
        return inventoryDataList;
    }

    private int[] range(int start, int end) {
        return IntStream.range(start, end).toArray();
    }

    private int[] reverseRange(int start, int end) {
        return IntStream.range(start, end).map(i -> end - 1 - (i - start)).toArray();
    }

    boolean isStacksEqual(ItemStack left, ItemStack right) {
        NBTTagCompound leftTag = left.func_77978_p();
        NBTTagCompound rightTag = right.func_77978_p();
        return left.func_77973_b() == right.func_77973_b() && left.func_77960_j() == right.func_77960_j() && (leftTag == null && rightTag == null || leftTag != null && leftTag.equals((Object)rightTag));
    }

    String getItemStackName(IInventory inventory) {
        if (inventory instanceof InventoryLargeChest) {
            return Block.func_149729_e((int)54).func_149732_F();
        }
        if (inventory instanceof TileEntityBrewingStand) {
            return StatCollector.func_74838_a((String)(Item.func_150899_d((int)379).func_77658_a() + ".name"));
        }
        if (inventory instanceof TileEntity) {
            TileEntity entity = (TileEntity)inventory;
            ItemStack itemStack = new ItemStack(entity.func_145838_q(), 1, entity.func_145832_p());
            return LocalizationHelper.getDisplayNameEnglish(itemStack);
        }
        return StatCollector.func_74838_a((String)inventory.func_145825_b());
    }

    int getMaxAllowedStackSize(IInventory inventory, ItemStack stack) {
        return Math.min(inventory.func_70297_j_(), stack.func_77976_d());
    }

    private boolean isInventoryValid(InventoryData inventoryData) {
        TileEntity entity = inventoryData.getEntities().get(0);
        if (entity instanceof TileEntityChest) {
            return true;
        }
        String inventoryName = this.getItemStackName(inventoryData.getInventory());
        return this.isInventoryNameValid(inventoryName);
    }

    private boolean isInventoryNameValid(String name) {
        String[] containerNames;
        for (String containerName : containerNames = BogoSorterConfig.dropOff.dropoffTargetNames) {
            if (!name.toLowerCase().contains(containerName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private <T extends TileEntity> InventoryData getInventoryData(T leftEntity) {
        ArrayList<TileEntity> entities = new ArrayList<TileEntity>();
        if (leftEntity instanceof TileEntityChest) {
            String chestName = "container.chestDouble";
            TileEntity rightEntity = this.world.func_147438_o(leftEntity.field_145851_c - 1, leftEntity.field_145848_d, leftEntity.field_145849_e);
            if (leftEntity.func_145838_q().func_149744_f()) {
                if (rightEntity instanceof TileEntityChest && rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)rightEntity, (IInventory)leftEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
                rightEntity = this.world.func_147438_o(leftEntity.field_145851_c + 1, leftEntity.field_145848_d, leftEntity.field_145849_e);
                if (rightEntity instanceof TileEntityChest && rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)leftEntity, (IInventory)rightEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
                rightEntity = this.world.func_147438_o(leftEntity.field_145851_c, leftEntity.field_145848_d, leftEntity.field_145849_e - 1);
                if (rightEntity instanceof TileEntityChest && rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)rightEntity, (IInventory)leftEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
                rightEntity = this.world.func_147438_o(leftEntity.field_145851_c, leftEntity.field_145848_d, leftEntity.field_145849_e + 1);
                if (rightEntity instanceof TileEntityChest && rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)leftEntity, (IInventory)rightEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
            } else {
                if (rightEntity instanceof TileEntityChest && !rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)rightEntity, (IInventory)leftEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
                rightEntity = this.world.func_147438_o(leftEntity.field_145851_c + 1, leftEntity.field_145848_d, leftEntity.field_145849_e);
                if (rightEntity instanceof TileEntityChest && !rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)leftEntity, (IInventory)rightEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
                rightEntity = this.world.func_147438_o(leftEntity.field_145851_c, leftEntity.field_145848_d, leftEntity.field_145849_e - 1);
                if (rightEntity instanceof TileEntityChest && !rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)rightEntity, (IInventory)leftEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
                rightEntity = this.world.func_147438_o(leftEntity.field_145851_c, leftEntity.field_145848_d, leftEntity.field_145849_e + 1);
                if (rightEntity instanceof TileEntityChest && !rightEntity.func_145838_q().func_149744_f()) {
                    InventoryLargeChest largeChest = new InventoryLargeChest(chestName, (IInventory)leftEntity, (IInventory)rightEntity);
                    entities.add(leftEntity);
                    entities.add(rightEntity);
                    return new InventoryData(entities, (IInventory)largeChest, InteractionResult.DROPOFF_FAIL);
                }
            }
        }
        entities.add(leftEntity);
        return new InventoryData(entities, (IInventory)leftEntity, InteractionResult.DROPOFF_FAIL);
    }

    private InventoryData getInventoryData(TileEntityEnderChest entity) {
        List<TileEntityEnderChest> entities = Collections.singletonList(entity);
        return new InventoryData(entities, (IInventory)this.player.func_71005_bN(), InteractionResult.DROPOFF_FAIL);
    }

    public abstract class Slots {
        public static final int LAST = -1;
        public static final int FIRST = 0;
        public static final int FURNACE_FUEL = 1;
        public static final int FURNACE_OUT = 2;
        public static final int PLAYER_INVENTORY_FIRST = 9;
        public static final int PLAYER_INVENTORY_LAST = 36;
    }
}

