/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.api.IButtonPos;
import com.cleanroommc.bogosorter.common.sort.ButtonHandler;
import java.util.Objects;

public class ButtonPos
implements IButtonPos {
    private boolean enabled = true;
    private int x = 0;
    private int y = 0;
    private IButtonPos.Alignment alignment = IButtonPos.Alignment.BOTTOM_RIGHT;
    private IButtonPos.Layout layout = IButtonPos.Layout.HORIZONTAL;

    public void reset() {
        this.enabled = true;
        this.x = 0;
        this.y = 0;
        this.alignment = IButtonPos.Alignment.BOTTOM_RIGHT;
        this.layout = IButtonPos.Layout.HORIZONTAL;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setAlignment(IButtonPos.Alignment alignment) {
        this.alignment = Objects.requireNonNull(alignment);
    }

    @Override
    public void setLayout(IButtonPos.Layout layout) {
        this.layout = Objects.requireNonNull(layout);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public IButtonPos.Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    public IButtonPos.Layout getLayout() {
        return this.layout;
    }

    public void applyPos(int guiLeft, int guiTop, ButtonHandler.SortButton sortButton, ButtonHandler.SortButton settingsButton) {
        int s = 10;
        boolean h = this.layout == IButtonPos.Layout.HORIZONTAL;
        switch (this.alignment) {
            case TOP_LEFT: {
                sortButton.field_146128_h = this.x;
                sortButton.field_146129_i = this.y;
                break;
            }
            case TOP_RIGHT: {
                sortButton.field_146128_h = h ? this.x - s - s : this.x - s;
                sortButton.field_146129_i = this.y;
                break;
            }
            case BOTTOM_LEFT: {
                sortButton.field_146128_h = this.x;
                sortButton.field_146129_i = h ? this.y - s : this.y - s - s;
                break;
            }
            case BOTTOM_RIGHT: {
                sortButton.field_146128_h = h ? this.x - s - s : this.x - s;
                sortButton.field_146129_i = h ? this.y - s : this.y - s - s;
            }
        }
        sortButton.field_146128_h += guiLeft;
        sortButton.field_146129_i += guiTop;
        if (h) {
            settingsButton.field_146128_h = sortButton.field_146128_h + s;
            settingsButton.field_146129_i = sortButton.field_146129_i;
        } else {
            settingsButton.field_146128_h = sortButton.field_146128_h;
            settingsButton.field_146129_i = sortButton.field_146129_i + s;
        }
    }
}

