/*
 * Decompiled with CFR 0.152.
 */
package openblocks.shapes;

import java.util.Set;
import net.minecraft.util.StatCollector;
import openmods.shapes.IShapeGenerator;
import openmods.shapes.ShapeAxesGenerator;
import openmods.shapes.ShapeCuboidGenerator;
import openmods.shapes.ShapeCylinderGenerator;
import openmods.shapes.ShapeEquilateral2dGenerator;
import openmods.shapes.ShapePlanesGenerator;
import openmods.shapes.ShapeSphereGenerator;
import openmods.utils.render.GeometryUtils;

public enum GuideShape {
    Sphere((IShapeGenerator)new ShapeSphereGenerator((Set)GeometryUtils.Octant.ALL), "sphere"),
    Cylinder((IShapeGenerator)new ShapeCylinderGenerator(), "cylinder"),
    Cuboid((IShapeGenerator)new ShapeCuboidGenerator(ShapeCuboidGenerator.Elements.EDGES), "cuboid"),
    FullCuboid((IShapeGenerator)new ShapeCuboidGenerator(ShapeCuboidGenerator.Elements.WALLS), "full_cuboid"),
    Dome((IShapeGenerator)new ShapeSphereGenerator((Set)GeometryUtils.Octant.SOUTH), "dome"),
    Triangle((IShapeGenerator)new ShapeEquilateral2dGenerator(3), "triangle"),
    Pentagon((IShapeGenerator)new ShapeEquilateral2dGenerator(5), "pentagon"),
    Hexagon((IShapeGenerator)new ShapeEquilateral2dGenerator(6), "hexagon"),
    Octagon((IShapeGenerator)new ShapeEquilateral2dGenerator(8), "octagon"),
    Axes((IShapeGenerator)new ShapeAxesGenerator(), "axes"),
    Planes((IShapeGenerator)new ShapePlanesGenerator(), "planes");

    public final String unlocalizedName;
    public final IShapeGenerator generator;
    public static final GuideShape[] VALUES;

    private GuideShape(IShapeGenerator generator, String name) {
        this.unlocalizedName = "openblocks.misc.shape." + name;
        this.generator = generator;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    static {
        VALUES = GuideShape.values();
    }
}

