/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class DestroyArea {
    StructureBoundingBox destroyBox;

    public DestroyArea(StructureBoundingBox tower, Random rand, int y) {
        int bx = tower.field_78897_a - 2 + rand.nextInt(tower.func_78883_b());
        int bz = tower.field_78896_c - 2 + rand.nextInt(tower.func_78880_d());
        this.destroyBox = new StructureBoundingBox(bx, y - 10, bz, bx + 4, y, bz + 4);
    }

    public boolean isEntirelyAbove(int y) {
        return this.destroyBox.field_78895_b > y;
    }

    public boolean isVecInside(int x, int y, int z) {
        return this.destroyBox.func_78890_b(x, y, z);
    }

    public static DestroyArea createNonIntersecting(StructureBoundingBox tower, Random rand, int y, ArrayList<DestroyArea> otherAreas) {
        int attempts = 100;
        DestroyArea area = null;
        for (int i = 0; i < attempts && area == null; ++i) {
            DestroyArea testArea = new DestroyArea(tower, rand, y);
            if (otherAreas.size() == 0) {
                area = testArea;
                continue;
            }
            for (DestroyArea otherArea : otherAreas) {
                if (otherArea != null && testArea.intersectsWith(otherArea)) continue;
                area = testArea;
            }
        }
        return area;
    }

    private boolean intersectsWith(DestroyArea otherArea) {
        return this.destroyBox.func_78885_a(otherArea.destroyBox.field_78897_a - 1, otherArea.destroyBox.field_78896_c - 1, otherArea.destroyBox.field_78893_d + 1, otherArea.destroyBox.field_78893_d + 1);
    }
}

