/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.utils;

import org.apache.logging.log4j.Logger;
import ru.timeconqueror.lootgames.api.Marker;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.lootgames.utils.future.MessageSupplier;
import ru.timeconqueror.timecore.api.util.EnvironmentUtils;

public class DebugLogger {
    private final Logger internal;

    public DebugLogger(Logger internal) {
        this.internal = internal;
    }

    public void debug(String message) {
        if (this.inDev()) {
            this.internal.info(message);
        } else {
            this.internal.debug(message);
        }
    }

    public void debug(String message, Object ... params) {
        if (this.inDev()) {
            this.internal.info(message, params);
        } else {
            this.internal.debug(message, params);
        }
    }

    public void debug(Marker marker, String message) {
        if (this.isMarkerEnabled(marker)) {
            if (this.inDev()) {
                this.internal.info(message);
            } else {
                this.internal.debug(message);
            }
        }
    }

    public void debug(Marker marker, String message, Object ... params) {
        if (this.isMarkerEnabled(marker)) {
            if (this.inDev()) {
                this.internal.info(message, params);
            } else {
                this.internal.debug(message, params);
            }
        }
    }

    public void debug(Marker marker, MessageSupplier supplier) {
        if (this.isMarkerEnabled(marker)) {
            if (this.inDev()) {
                this.internal.info(supplier.get());
            } else {
                this.internal.debug(supplier.get());
            }
        }
    }

    private boolean inDev() {
        return EnvironmentUtils.isInDev();
    }

    private boolean isMarkerEnabled(Marker marker) {
        return LGConfigs.GENERAL.enabledMarkers.contains((Object)marker);
    }
}

