/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.util;

import java.lang.reflect.Array;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import ru.timeconqueror.lootgames.utils.future.ICodec;

public class CodecUtils {
    public static <T> T[][] read2DimArr(NBTTagCompound tableTag, Class<T> elementClass, ICodec<T, NBTTagCompound> elementCodec) {
        int size = tableTag.func_74762_e("size");
        Object[][] table = null;
        for (int i = 0; i < size; ++i) {
            NBTTagCompound columnTag = tableTag.func_74775_l(Integer.toString(i));
            int columnSize = columnTag.func_74762_e("size");
            Object[] column = (Object[])Array.newInstance(elementClass, columnSize);
            for (int j = 0; j < columnSize; ++j) {
                if (!columnTag.func_74764_b(Integer.toString(j))) continue;
                NBTTagCompound elementTag = columnTag.func_74775_l(Integer.toString(j));
                T element = elementCodec.decode(elementTag);
                column[j] = element;
            }
            if (i == 0) {
                Class<?> columnClass = column.getClass();
                table = (Object[][])Array.newInstance(columnClass, size);
            }
            table[i] = column;
        }
        return table;
    }

    public static <T> NBTTagCompound write2DimArr(T[][] objArr, ICodec<T, NBTTagCompound> elementCodec) {
        return CodecUtils.write2DimArr(objArr, elementCodec, e -> true);
    }

    public static <T> NBTTagCompound write2DimArr(T[][] objArr, ICodec<T, NBTTagCompound> elementCodec, Predicate<T> writeElementIf) {
        NBTTagCompound tableTag = new NBTTagCompound();
        for (int i = 0; i < objArr.length; ++i) {
            NBTTagCompound column = new NBTTagCompound();
            for (int j = 0; j < objArr[i].length; ++j) {
                if (!writeElementIf.test(objArr[i][j])) continue;
                NBTTagCompound elementTag = elementCodec.encode(objArr[i][j]);
                column.func_74782_a(Integer.toString(j), (NBTBase)elementTag);
            }
            column.func_74768_a("size", objArr[i].length);
            tableTag.func_74782_a(Integer.toString(i), (NBTBase)column);
        }
        tableTag.func_74768_a("size", objArr.length);
        return tableTag;
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String message) {
            super(message);
        }

        public NotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotFoundException(Throwable cause) {
            super(cause);
        }

        public NotFoundException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

