/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.tcwands.api;

import gregtech.api.enums.Materials;
import gregtech.api.util.GTModHandler;
import java.util.function.Supplier;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public enum GTTier {
    LV(0, Materials.Aluminium, () -> GTModHandler.getModItem((String)"TwilightForest", (String)"item.nagaScale", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151015_O))),
    MV(1, Materials.StainlessSteel, () -> GTModHandler.getModItem((String)"dreamcraft", (String)"item.LichBone", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151172_bF))),
    HV(2, Materials.EnergeticAlloy, () -> GTModHandler.getModItem((String)"dreamcraft", (String)"item.LichBone", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151172_bF))),
    EV(3, Materials.VibrantAlloy, () -> GTModHandler.getModItem((String)"TwilightForest", (String)"item.fieryBlood", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151174_bG))),
    IV(4, Materials.TungstenSteel, () -> GTModHandler.getModItem((String)"TwilightForest", (String)"item.fieryTears", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151170_bI))),
    LUV(5, Materials.Enderium, () -> GTModHandler.getModItem((String)"TwilightForest", (String)"item.carminite", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151034_e))),
    ZPM(6, Materials.Oriharukon, () -> GTModHandler.getModItem((String)"TwilightForest", (String)"item.carminite", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151034_e))),
    UV(7, Materials.Osmiridium, () -> GTModHandler.getModItem((String)"dreamcraft", (String)"item.SnowQueenBlood", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151105_aU)));

    private static final GTTier[] tiers;
    private final int index;
    private final Materials material;
    private Supplier<ItemStack> wandConductorSupplier;

    private GTTier(int index, Materials material, Supplier<ItemStack> wandConductorSupplier) {
        this.index = index;
        this.material = material;
        this.wandConductorSupplier = wandConductorSupplier;
    }

    public static void init() {
        for (GTTier tier : GTTier.values()) {
            ItemStack conductor = tier.wandConductorSupplier.get();
            tier.wandConductorSupplier = () -> conductor;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Materials getMaterial() {
        return this.material;
    }

    public ItemStack getConductor() {
        return this.wandConductorSupplier.get();
    }

    public GTTier nextTier() {
        if (this.getIndex() >= tiers.length - 1) {
            return this;
        }
        return tiers[this.getIndex() + 1];
    }

    static {
        GTTier[] values = GTTier.values();
        tiers = new GTTier[values.length];
        GTTier[] gTTierArray = values;
        int n = gTTierArray.length;
        for (int i = 0; i < n; ++i) {
            GTTier tier;
            GTTier.tiers[tier.getIndex()] = tier = gTTierArray[i];
        }
    }
}

