/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.tcwands.api;

import com.gtnewhorizons.tcwands.api.GTTier;
import com.gtnewhorizons.tcwands.api.IWandRegistry;
import com.gtnewhorizons.tcwands.api.wrappers.AbstractWandWrapper;
import com.gtnewhorizons.tcwands.api.wrappers.CapWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandRodOnUpdate;
import thaumcraft.api.wands.StaffRod;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;

public class TCWandAPI {
    private static ArrayList<Object> craftingRecipes;
    private static final ArrayList<IWandRegistry> registries;
    private static final ArrayList<AbstractWandWrapper> wandWrappers;
    private static final ArrayList<CapWrapper> caps;

    public static void addRegistry(IWandRegistry registry) {
        registries.add(registry);
    }

    public static void init() {
        GTTier.init();
        TCWandAPI.removeTCWands();
        for (IWandRegistry registry : registries) {
            registry.register();
        }
        TCWandAPI.makeWands();
    }

    public static void regWandWrapper(AbstractWandWrapper wandWrapper) {
        wandWrappers.add(wandWrapper);
    }

    public static void regCap(CapWrapper cap) {
        caps.add(cap);
    }

    private static void makeWands() {
        for (AbstractWandWrapper wandWrapper : wandWrappers) {
            for (CapWrapper cap : caps) {
                TCWandAPI.regRecipe(wandWrapper, cap);
            }
        }
    }

    private static void regRecipe(AbstractWandWrapper wandWrapper, CapWrapper cap) {
        AspectList aspects = new AspectList();
        for (Aspect a : Aspect.getPrimalAspects()) {
            aspects.add(a, wandWrapper.getRecipeCost(cap));
        }
        ItemStack wand = wandWrapper.getItem(cap);
        ThaumcraftApi.addArcaneCraftingRecipe((String)wandWrapper.getResearchName(), (ItemStack)wand, (AspectList)aspects, (Object[])wandWrapper.genRecipe(cap));
    }

    public static void makeRod(String name, int capacity, ItemStack item, int craftCost, IWandRodOnUpdate update, boolean glowing, ResourceLocation texture) {
        WandRod rod = new WandRod(name, capacity, item, craftCost, texture);
        rod.setGlowing(glowing);
        if (update != null) {
            rod.setOnUpdate(update);
        }
    }

    public static void makeStaff(String name, int capacity, ItemStack item, int cost, IWandRodOnUpdate update, boolean glowing, ResourceLocation texture) {
        StaffRod staff = new StaffRod(name, capacity, item, cost, texture);
        staff.setGlowing(glowing);
        if (update != null) {
            staff.setOnUpdate(update);
        }
    }

    public static void makeCap(String name, ItemStack stack, float discount, int cost, ResourceLocation texture) {
        WandCap cap = new WandCap(name, discount, stack, cost);
        cap.setTexture(texture);
    }

    public static void makeCap(String name, ItemStack stack, float discount, List<Aspect> list, float discountSpecial, int cost, ResourceLocation texture) {
        WandCap cap = new WandCap(name, discount, list, discountSpecial, stack, cost);
        cap.setTexture(texture);
    }

    private static void removeTCWands() {
        craftingRecipes.removeIf(r -> r instanceof ArcaneWandRecipe || r instanceof ArcaneSceptreRecipe);
    }

    public static ArrayList<CapWrapper> getCaps() {
        return caps;
    }

    public static ArrayList<AbstractWandWrapper> getWandWrappers() {
        return wandWrappers;
    }

    static {
        registries = new ArrayList();
        wandWrappers = new ArrayList();
        caps = new ArrayList();
        try {
            Field f = ThaumcraftApi.class.getDeclaredField("craftingRecipes");
            f.setAccessible(true);
            craftingRecipes = (ArrayList)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

