/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.api.carts.locomotive.IRenderer;
import mods.railcraft.api.carts.locomotive.LocomotiveModelRenderer;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.client.emblems.EmblemToolsClient;
import mods.railcraft.client.render.carts.CartModelRenderer;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.ResourceLocation;

public class LocomotiveRenderer
extends CartModelRenderer {
    public static final LocomotiveRenderer INSTANCE = new LocomotiveRenderer();

    @Override
    public boolean render(IRenderer renderer, EntityMinecart cart, float light, float time) {
        EntityLocomotive loco = (EntityLocomotive)cart;
        int primaryColor = EnumColor.fromId(loco.getPrimaryColor()).getHexColor();
        int secondaryColor = EnumColor.fromId(loco.getSecondaryColor()).getHexColor();
        String emblem = loco.getEmblem();
        ResourceLocation emblemTexture = null;
        if (emblem != null && !emblem.equals("") && EmblemToolsClient.packageManager != null) {
            emblemTexture = EmblemToolsClient.packageManager.getEmblemTextureLocation(emblem);
        }
        LocomotiveRenderType renderType = loco.getRenderType();
        LocomotiveModelRenderer locoRenderer = renderType.getRenderer(loco.getModel());
        locoRenderer.renderLocomotive(renderer, cart, primaryColor, secondaryColor, emblemTexture, light, time);
        return false;
    }
}

