/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.core.INetworkedObject;
import mods.railcraft.api.core.IOwnable;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketBuilder;
import mods.railcraft.common.util.network.PacketTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class RailcraftTileEntity
extends TileEntity
implements INetworkedObject,
IOwnable {
    protected final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    protected int clock = MiscTools.getRand().nextInt();
    private GameProfile owner = new GameProfile(null, "[Railcraft]");
    private boolean sendClientUpdate = false;
    private UUID uuid;

    public static boolean isUseableByPlayerHelper(TileEntity tile, EntityPlayer player) {
        if (tile.func_145837_r()) {
            return false;
        }
        if (tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) != tile) {
            return false;
        }
        return player.func_70092_e((double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e) <= 64.0;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void func_145845_h() {
        super.func_145845_h();
        ++this.clock;
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            PacketBuilder.instance().sendTileEntityPacket(this);
        }
    }

    public FMLProxyPacket getDescriptionPacket() {
        PacketTileEntity packet = new PacketTileEntity(this);
        return packet.getPacket();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
    }

    public void markBlockForUpdate() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void notifyBlocksOfNeighborChange() {
        if (this.field_145850_b != null) {
            WorldPlugin.notifyBlocksOfNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void sendUpdateToClient() {
        if (this.canUpdate()) {
            this.sendClientUpdate = true;
        } else {
            PacketBuilder.instance().sendTileEntityPacket(this);
        }
    }

    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        if (entityliving instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entityliving).func_146103_bH();
        }
    }

    public void onNeighborBlockChange(Block id) {
        this.tileCache.onNeighborChange();
    }

    public void func_145843_s() {
        this.tileCache.purge();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.tileCache.purge();
        super.func_145829_t();
    }

    public final int getDimension() {
        if (this.field_145850_b == null) {
            return 0;
        }
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    @Override
    public final GameProfile getOwner() {
        return this.owner;
    }

    public boolean isOwner(GameProfile player) {
        return PlayerPlugin.isSamePlayer(this.owner, player);
    }

    public String getName() {
        return LocalizationPlugin.translate(this.getLocalizationTag());
    }

    @Override
    public abstract String getLocalizationTag();

    public List<String> getDebugOutput() {
        ArrayList<String> debug = new ArrayList<String>();
        debug.add("Railcraft Tile Entity Data Dump");
        debug.add("Object: " + this);
        debug.add(String.format("Coordinates: d=%d, %d,%d,%d", this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        debug.add("Owner: " + (this.owner == null ? "null" : this.owner.getName()));
        debug.addAll(this.tileCache.getDebugOutput());
        return debug;
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.owner.getName() != null) {
            data.func_74778_a("owner", this.owner.getName());
        }
        if (this.owner.getId() != null) {
            data.func_74778_a("ownerId", this.owner.getId().toString());
        }
        MiscTools.writeUUID(data, "uuid", this.uuid);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.owner = PlayerPlugin.readOwnerFromNBT(data);
        this.uuid = MiscTools.readUUID(data, "uuid");
    }

    public final int getX() {
        return this.field_145851_c;
    }

    public final int getY() {
        return this.field_145848_d;
    }

    public final int getZ() {
        return this.field_145849_e;
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    public abstract short getId();
}

