/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import java.util.List;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.slab.TileSlab;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSlab
extends ItemBlock {
    public ItemSlab(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("railcraft.slab");
    }

    public String func_77667_c(ItemStack stack) {
        return BlockRailcraftSlab.getTag(EnumBlockMaterial.fromOrdinal(stack.func_77960_j()));
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (this.isSingleSlab(world, x, y, z, side)) {
            this.tryAddSlab(world, x, y, z, stack);
            return true;
        }
        if (this.isSingleSlabShifted(world, x, y, z, side)) {
            ForgeDirection s = ForgeDirection.getOrientation((int)side);
            x = MiscTools.getXOnSide(x, s);
            y = MiscTools.getYOnSide(y, s);
            z = MiscTools.getZOnSide(z, s);
            this.tryAddSlab(world, x, y, z, stack);
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    private boolean isSingleSlab(World world, int x, int y, int z, int side) {
        TileSlab slab;
        if (world.func_147439_a(x, y, z) == this.field_150939_a && (slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z)) != null) {
            boolean up = slab.isTopSlab();
            if ((side == 1 && !up || side == 0 && up) && !slab.isDoubleSlab()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSingleSlabShifted(World world, int x, int y, int z, int side) {
        TileSlab slab;
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        return world.func_147439_a(x = MiscTools.getXOnSide(x, s), y = MiscTools.getYOnSide(y, s), z = MiscTools.getZOnSide(z, s)) == this.field_150939_a && (slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z)) != null && !slab.isDoubleSlab();
    }

    private void tryAddSlab(World world, int x, int y, int z, ItemStack stack) {
        BlockRailcraftSlab block;
        TileSlab slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
        if (slab != null && world.func_72855_b((block = BlockRailcraftSlab.getBlock()).func_149668_a(world, x, y, z)) && slab.addSlab(EnumBlockMaterial.fromOrdinal(stack.func_77960_j()))) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ((Block)block).field_149762_H.func_150496_b(), (((Block)block).field_149762_H.func_150497_c() + 1.0f) / 2.0f, ((Block)block).field_149762_H.func_150494_d() * 0.8f);
            --stack.field_77994_a;
        }
    }

    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer par6EntityPlayer, ItemStack stack) {
        if (this.isSingleSlab(world, x, y, z, side)) {
            return true;
        }
        if (this.isSingleSlabShifted(world, x, y, z, side)) {
            return true;
        }
        return super.func_150936_a(world, x, y, z, side, par6EntityPlayer, stack);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        Block block = this.field_150939_a;
        if (!world.func_72855_b(block.func_149668_a(world, x, y, z))) {
            return false;
        }
        if (!world.func_147449_b(x, y, z, this.field_150939_a)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == this.field_150939_a) {
            TileSlab slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
            if (slab != null) {
                if (side != 0 && (side == 1 || (double)hitY <= 0.5)) {
                    slab.setBottomSlab(EnumBlockMaterial.fromOrdinal(stack.func_77960_j()));
                } else {
                    slab.setTopSlab(EnumBlockMaterial.fromOrdinal(stack.func_77960_j()));
                }
            }
            this.field_150939_a.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            this.field_150939_a.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        info.add(LocalizationPlugin.translate("item.nomobspawnsonthisblock.tip"));
    }
}

