/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy")})
public class TileFluxTransformer
extends TileMultiBlock
implements IElectricGrid,
IEnergyHandler {
    public static final double EU_RF_RATIO = 4.0;
    public static final double EFFICIENCY = (double)0.8f;
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.BLOCK, 0.25);

    public static void placeFluxTransformer(World world, int x, int y, int z) {
        Iterator<MultiBlockPattern> iterator = patterns.iterator();
        if (iterator.hasNext()) {
            MultiBlockPattern pattern = iterator.next();
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('B'), EnumMachineEpsilon.FLUX_TRANSFORMER.ordinal());
            pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineEpsilon(), blockMapping);
            return;
        }
    }

    public TileFluxTransformer() {
        super(patterns);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.chargeHandler.tick();
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineEpsilon.FLUX_TRANSFORMER;
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.isStructureValid()) {
            return 0;
        }
        double chargeDifference = this.chargeHandler.getCapacity() - this.chargeHandler.getCharge();
        if (chargeDifference > 0.0) {
            if (!simulate) {
                this.chargeHandler.addCharge((double)maxReceive / 4.0 * (double)0.8f);
            }
            return maxReceive;
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.chargeHandler.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.chargeHandler.writeToNBT(data);
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'*', 'O', 'O', '*'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'*', 'O', 'O', '*'}}, new char[][]{{'*', 'O', 'O', '*'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'*', 'O', 'O', '*'}}, new char[][]{{'*', 'O', 'O', '*'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'*', 'O', 'O', '*'}}, new char[][]{{'*', 'O', 'O', '*'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'*', 'O', 'O', '*'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

