/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import cpw.mods.fml.common.eventhandler.Event;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.events.CartLockdownEvent;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.locking.BoardingLockingProfile;
import mods.railcraft.common.blocks.tracks.locking.HoldingLockingProfile;
import mods.railcraft.common.blocks.tracks.locking.LockdownLockingProfile;
import mods.railcraft.common.blocks.tracks.locking.LockingProfile;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.MinecraftForge;

public class TrackNextGenLocking
extends TrackBaseRailcraft
implements ITrackLockdown,
ITrackPowered {
    public static double START_BOOST = 0.04;
    public static double BOOST_FACTOR = 0.06;
    private LockingProfileType profile = LockingProfileType.LOCKDOWN;
    private LockingProfile profileInstance = this.profile.create(this);
    private EntityMinecart currentCart;
    private EntityMinecart prevCart;
    private Train currentTrain;
    private UUID uuid;
    private boolean trainLeaving = false;
    private boolean redstone = false;
    private boolean locked = false;
    private int trainDelay = 0;
    private UUID prevCartUUID;
    private UUID currentCartUUID;
    private boolean justLoaded = true;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LOCKING;
    }

    @Override
    public IIcon getIcon() {
        if (!this.locked) {
            return this.getIcon(this.profile.ordinal() * 2);
        }
        return this.getIcon(this.profile.ordinal() * 2 + 1);
    }

    public LockingProfileType getProfileType() {
        return this.profile;
    }

    public void setProfile(LockingProfileType type) {
        this.profile = type;
        this.profileInstance = this.profile.create(this);
        if (this.tileEntity != null && Game.isHost(this.getWorld())) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (Game.isHost(this.getWorld())) {
            boolean updateClient = false;
            if (this.justLoaded) {
                this.prevCart = LinkageManager.instance().getCartFromUUID(this.prevCartUUID);
                this.currentCart = LinkageManager.instance().getCartFromUUID(this.currentCartUUID);
                this.justLoaded = false;
                updateClient = true;
            }
            if (this.currentCart != null && this.currentCart.field_70128_L) {
                this.releaseCurrentCart();
                this.currentCart = null;
                updateClient = true;
            }
            boolean oldLocked = this.locked;
            this.calculateLocked();
            if (oldLocked != this.locked) {
                updateClient = true;
            }
            if (this.locked) {
                this.lockCurrentCart();
            } else {
                this.releaseCurrentCart();
            }
            if (this.currentCart != null) {
                this.prevCart = this.currentCart;
            }
            this.currentCart = null;
            if (updateClient) {
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            LockingProfileType p = player.func_70093_af() ? this.profile.previous() : this.profile.next();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            if (Game.isHost(this.getWorld())) {
                this.setProfile(p);
            } else {
                ChatPlugin.sendLocalizedChat(player, "railcraft.gui.track.mode.change", "\u00a75" + LocalizationPlugin.translate("railcraft.gui.track.locking.mode." + p.tag));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        this.releaseCart();
    }

    private UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    private void lockCurrentCart() {
        if (this.currentCart != null) {
            Train train = Train.getTrain(this.currentCart);
            if (this.currentTrain != train && this.currentTrain != null) {
                this.currentTrain.removeLockingTrack(this.getUUID());
            }
            this.currentTrain = train;
            this.currentTrain.addLockingTrack(this.getUUID());
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Lock(this.currentCart, this.getX(), this.getY(), this.getZ()));
            this.profileInstance.onLock(this.currentCart);
            this.currentCart.field_70159_w = 0.0;
            this.currentCart.field_70179_y = 0.0;
            int meta = this.tileEntity.func_145832_p();
            if (meta == 0 || meta == 4 || meta == 5) {
                this.currentCart.field_70161_v = (double)this.tileEntity.field_145849_e + 0.5;
            } else {
                this.currentCart.field_70165_t = (double)this.tileEntity.field_145851_c + 0.5;
            }
        }
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        this.currentCart = cart;
    }

    private void releaseCurrentCart() {
        if (this.currentTrain != null) {
            this.currentTrain.removeLockingTrack(this.getUUID());
        }
        if (this.currentCart != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Release(this.currentCart, this.getX(), this.getY(), this.getZ()));
            this.profileInstance.onRelease(this.currentCart);
        }
    }

    @Override
    public void releaseCart() {
        this.trainLeaving = true;
    }

    @Override
    public boolean isCartLockedDown(EntityMinecart cart) {
        return this.locked && this.prevCart == cart;
    }

    private boolean isSameTrainOrCart() {
        if (this.profile.lockType == LockType.TRAIN) {
            if (this.currentCart != null) {
                this.trainDelay = Train.areInSameTrain(this.currentCart, this.prevCart) ? 200 : 0;
            } else if (this.trainLeaving) {
                List<EntityMinecart> carts = CartTools.getMinecartsAt(this.getWorld(), this.getX(), this.getY(), this.getZ(), 0.0f);
                for (EntityMinecart cart : carts) {
                    if (!Train.areInSameTrain(cart, this.prevCart)) continue;
                    this.trainDelay = 200;
                    break;
                }
            }
            if (this.trainDelay > 0) {
                --this.trainDelay;
            } else {
                this.prevCart = null;
            }
            return this.trainDelay > 0;
        }
        return this.currentCart != null && this.profile.lockType == LockType.CART && this.currentCart == this.prevCart;
    }

    private void calculateLocked() {
        boolean isSameCart = this.isSameTrainOrCart();
        if (this.trainLeaving) {
            if (!isSameCart && !this.redstone) {
                this.trainLeaving = false;
            }
            this.locked = !isSameCart && !this.redstone;
        } else {
            if (isSameCart && this.redstone) {
                this.trainLeaving = true;
            }
            this.locked = !this.redstone;
        }
    }

    @Override
    public boolean isPowered() {
        return this.redstone;
    }

    @Override
    public void setPowered(boolean powered) {
        this.redstone = powered;
    }

    private void setUUID(UUID id, String key, NBTTagCompound data) {
        if (id == null) {
            data.func_74772_a(key + "High", 0L);
            data.func_74772_a(key + "Low", 0L);
        } else {
            data.func_74772_a(key + "High", id.getMostSignificantBits());
            data.func_74772_a(key + "Low", id.getLeastSignificantBits());
        }
    }

    private UUID readUUID(String key, NBTTagCompound data) {
        if (data.func_74764_b(key + "High")) {
            return new UUID(data.func_74763_f(key + "High"), data.func_74763_f(key + "Low"));
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("profile", (byte)this.profile.ordinal());
        this.profileInstance.writeToNBT(data);
        data.func_74757_a("powered", this.redstone);
        data.func_74757_a("locked", this.locked);
        data.func_74757_a("trainLeaving", this.trainLeaving);
        data.func_74768_a("trainDelay", this.trainDelay);
        if (this.prevCart != null) {
            this.setUUID(this.prevCart.getPersistentID(), "prevCart", data);
        }
        if (this.currentCart != null) {
            this.setUUID(this.currentCart.getPersistentID(), "currentCart", data);
        }
        this.setUUID(this.getUUID(), "uuid", data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("profile")) {
            this.profile = LockingProfileType.fromOrdinal(data.func_74771_c("profile"));
        }
        this.profileInstance = this.profile.create(this);
        this.profileInstance.readFromNBT(data);
        this.redstone = data.func_74767_n("powered");
        if (data.func_74764_b("locked")) {
            this.locked = data.func_74767_n("locked");
        }
        if (data.func_74764_b("trainLeaving")) {
            this.trainLeaving = data.func_74767_n("trainLeaving");
        }
        if (data.func_74764_b("trainDelay")) {
            this.trainDelay = data.func_74762_e("trainDelay");
        }
        this.prevCartUUID = this.readUUID("prevCart", data);
        this.currentCartUUID = this.readUUID("currentCart", data);
        this.uuid = this.readUUID("uuid", data);
        this.justLoaded = true;
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.profile.ordinal());
        data.writeBoolean(this.redstone);
        data.writeBoolean(this.locked);
        this.profileInstance.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        LockingProfileType p = LockingProfileType.fromOrdinal(data.readByte());
        if (this.profile != p) {
            this.profile = p;
            this.profileInstance = p.create(this);
        }
        this.redstone = data.readBoolean();
        this.locked = data.readBoolean();
        this.profileInstance.readPacketData(data);
        this.markBlockNeedsUpdate();
    }

    public static enum LockingProfileType {
        LOCKDOWN(LockdownLockingProfile.class, LockType.CART, "lockdown"),
        LOCKDOWN_TRAIN(LockdownLockingProfile.class, LockType.TRAIN, "lockdown.train"),
        HOLDING(HoldingLockingProfile.class, LockType.CART, "holding"),
        HOLDING_TRAIN(HoldingLockingProfile.class, LockType.TRAIN, "holding.train"),
        BOARDING_A(BoardingLockingProfile.class, LockType.CART, "boarding"),
        BOARDING_B(BoardingLockingProfile.class, LockType.CART, "boarding"),
        BOARDING_A_TRAIN(BoardingLockingProfile.class, LockType.TRAIN, "boarding.train"),
        BOARDING_B_TRAIN(BoardingLockingProfile.class, LockType.TRAIN, "boarding.train");

        public static final LockingProfileType[] VALUES;
        public final LockType lockType;
        public final String tag;
        private final Class<? extends LockingProfile> profileClass;

        private LockingProfileType(Class<? extends LockingProfile> profileClass, LockType lockType, String tag) {
            this.profileClass = profileClass;
            this.lockType = lockType;
            this.tag = tag;
        }

        public static LockingProfileType fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return LOCKDOWN;
            }
            return VALUES[ordinal];
        }

        public LockingProfileType next() {
            LockingProfileType next = VALUES[(this.ordinal() + 1) % VALUES.length];
            return next;
        }

        public LockingProfileType previous() {
            LockingProfileType next = VALUES[(this.ordinal() + VALUES.length - 1) % VALUES.length];
            return next;
        }

        public LockingProfile create(TrackNextGenLocking track) {
            try {
                Constructor<? extends LockingProfile> con = this.profileClass.getConstructor(TrackNextGenLocking.class);
                return con.newInstance(track);
            }
            catch (Throwable ex) {
                Game.logThrowable("Failed to create Locking Profile!", 10, ex, new Object[0]);
                throw new RuntimeException(ex);
            }
        }

        static {
            VALUES = LockingProfileType.values();
        }
    }

    public static enum LockType {
        CART,
        TRAIN;

    }
}

