/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mods.railcraft.api.electricity.IElectricMinecart;
import mods.railcraft.common.carts.EntityCartEnergy;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.LinkageManager;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;

public class Train
implements Iterable<EntityMinecart> {
    public static final String TRAIN_HIGH = "rcTrainHigh";
    public static final String TRAIN_LOW = "rcTrainLow";
    private static final Map<UUID, Train> trains = new HashMap<UUID, Train>();
    private final UUID uuid;
    private final LinkedList<UUID> carts = new LinkedList();
    private final List<UUID> safeCarts = Collections.unmodifiableList(this.carts);
    private final Set<UUID> lockingTracks = new HashSet<UUID>();
    private TrainState trainState = TrainState.NORMAL;

    public Train(EntityMinecart cart) {
        this.uuid = UUID.randomUUID();
        this.buildTrain(null, cart);
    }

    public static Train getTrain(EntityMinecart cart) {
        if (cart == null) {
            return null;
        }
        Train train = trains.get(Train.getTrainUUID(cart));
        if (train != null && !train.containsCart(cart)) {
            train.releaseTrain();
            trains.remove(train.getUUID());
            train = null;
        }
        if (train != null) {
            train.validate();
            if (train.isEmpty()) {
                train = null;
            }
        }
        if (train == null) {
            train = new Train(cart);
            trains.put(train.getUUID(), train);
        }
        return train;
    }

    private static Train getTrainUnsafe(EntityMinecart cart) {
        if (cart == null) {
            return null;
        }
        return trains.get(Train.getTrainUUID(cart));
    }

    public static UUID getTrainUUID(EntityMinecart cart) {
        NBTTagCompound nbt = cart.getEntityData();
        if (nbt.func_74764_b(TRAIN_HIGH)) {
            long high = nbt.func_74763_f(TRAIN_HIGH);
            long low = nbt.func_74763_f(TRAIN_LOW);
            return new UUID(high, low);
        }
        return null;
    }

    public static void resetTrain(EntityMinecart cart) {
        Train train = trains.remove(Train.getTrainUUID(cart));
        if (train != null) {
            train.releaseTrain();
        }
    }

    public static void resetTrain(UUID uuid) {
        Train train = trains.remove(uuid);
        if (train != null) {
            train.releaseTrain();
        }
    }

    public static boolean areInSameTrain(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == null || cart2 == null) {
            return false;
        }
        if (cart1 == cart2) {
            return true;
        }
        UUID train1 = Train.getTrainUUID(cart1);
        UUID train2 = Train.getTrainUUID(cart2);
        return train1 != null && train1.equals(train2);
    }

    public static Train getLongestTrain(EntityMinecart cart1, EntityMinecart cart2) {
        Train train2;
        Train train1 = Train.getTrain(cart1);
        if (train1 == (train2 = Train.getTrain(cart2))) {
            return train1;
        }
        if (train1.size() >= train2.size()) {
            return train1;
        }
        return train2;
    }

    public static void removeTrainTag(EntityMinecart cart) {
        cart.getEntityData().func_82580_o(TRAIN_HIGH);
        cart.getEntityData().func_82580_o(TRAIN_LOW);
    }

    public static void addTrainTag(EntityMinecart cart, Train train) {
        UUID trainId = train.getUUID();
        cart.getEntityData().func_74772_a(TRAIN_HIGH, trainId.getMostSignificantBits());
        cart.getEntityData().func_74772_a(TRAIN_LOW, trainId.getLeastSignificantBits());
    }

    public Train getTrain(UUID cartUUID) {
        if (cartUUID == null) {
            return null;
        }
        EntityMinecart cart = LinkageManager.instance().getCartFromUUID(cartUUID);
        if (cart == null) {
            return null;
        }
        return Train.getTrain(cart);
    }

    @Override
    public Iterator<EntityMinecart> iterator() {
        LinkageManager lm = LinkageManager.instance();
        ArrayList<EntityMinecart> entities = new ArrayList<EntityMinecart>(this.carts.size());
        for (UUID cart : this.carts) {
            EntityMinecart entity = lm.getCartFromUUID(cart);
            if (entity == null) continue;
            entities.add(entity);
        }
        return entities.iterator();
    }

    public Iterable<EntityMinecart> orderedIteratable(final EntityMinecart head) {
        return new Iterable<EntityMinecart>(){

            @Override
            public Iterator<EntityMinecart> iterator() {
                return new Iterator<EntityMinecart>(){
                    private final LinkageManager lm = LinkageManager.instance();
                    private EntityMinecart last = null;
                    private EntityMinecart current;
                    {
                        this.current = head;
                    }

                    @Override
                    public boolean hasNext() {
                        EntityMinecart next = this.lm.getLinkedCartA(this.current);
                        if (next != null && next != this.last) {
                            return true;
                        }
                        next = this.lm.getLinkedCartB(this.current);
                        return next != null && next != this.last;
                    }

                    @Override
                    public EntityMinecart next() {
                        EntityMinecart next = this.lm.getLinkedCartA(this.current);
                        if (next != this.last) {
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        next = this.lm.getLinkedCartB(this.current);
                        if (next != this.last) {
                            this.last = this.current;
                            this.current = next;
                            return this.current;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removing not supported.");
                    }
                };
            }
        };
    }

    private void buildTrain(EntityMinecart prev, EntityMinecart next) {
        this._addLink(prev, next);
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(next);
        EntityMinecart linkB = lm.getLinkedCartB(next);
        if (linkA != null && linkA != prev && !this.containsCart(linkA)) {
            this.buildTrain(next, linkA);
        }
        if (linkB != null && linkB != prev && !this.containsCart(linkB)) {
            this.buildTrain(next, linkB);
        }
    }

    private void dropCarts(EntityMinecart cart) {
        this._removeCart(cart);
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        if (linkA != null && this.containsCart(linkA)) {
            this.dropCarts(linkA);
        }
        if (linkB != null && this.containsCart(linkB)) {
            this.dropCarts(linkB);
        }
    }

    public void validate() {
        if (!this.isValid()) {
            UUID first = null;
            for (UUID id : this.carts) {
                if (!this.isCartValid(id)) continue;
                first = id;
                break;
            }
            this.releaseTrain();
            if (first == null) {
                trains.remove(this.getUUID());
            } else {
                this.buildTrain(null, LinkageManager.instance().getCartFromUUID(first));
            }
        }
    }

    private boolean isValid() {
        for (UUID id : this.carts) {
            if (this.isCartValid(id)) continue;
            return false;
        }
        return true;
    }

    private boolean isCartValid(UUID cartId) {
        EntityMinecart cart = LinkageManager.instance().getCartFromUUID(cartId);
        return cart != null && this.uuid.equals(Train.getTrainUUID(cart));
    }

    protected void releaseTrain() {
        LinkageManager lm = LinkageManager.instance();
        for (UUID id : this.carts) {
            EntityMinecart cart = lm.getCartFromUUID(id);
            if (cart == null) continue;
            Train.removeTrainTag(cart);
        }
        this.carts.clear();
        this.lockingTracks.clear();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void removeAllLinkedCarts(EntityMinecart cart) {
        UUID cartId = cart.getPersistentID();
        if (this.carts.contains(cartId)) {
            this.dropCarts(cart);
        }
    }

    public void addLink(EntityMinecart cart1, EntityMinecart cart2) {
        if (this.isTrainEnd(cart1)) {
            this.buildTrain(cart1, cart2);
        } else if (this.isTrainEnd(cart2)) {
            this.buildTrain(cart2, cart1);
        }
    }

    private void _addLink(EntityMinecart cartBase, EntityMinecart cartNew) {
        if (cartBase == null || this.carts.getFirst() == cartBase.getPersistentID()) {
            this.carts.addFirst(cartNew.getPersistentID());
        } else if (this.carts.getLast() == cartBase.getPersistentID()) {
            this.carts.addLast(cartNew.getPersistentID());
        } else {
            return;
        }
        Train train = Train.getTrainUnsafe(cartNew);
        if (train != null && train != this) {
            train._removeCart(cartNew);
        }
        Train.addTrainTag(cartNew, this);
    }

    private boolean _removeCart(EntityMinecart cart) {
        boolean removed = this._removeCart(cart.getPersistentID());
        if (removed && this.uuid.equals(Train.getTrainUUID(cart))) {
            Train.removeTrainTag(cart);
        }
        return removed;
    }

    private boolean _removeCart(UUID cart) {
        boolean removed = this.carts.remove(cart);
        if (removed && this.carts.isEmpty()) {
            this.releaseTrain();
            trains.remove(this.getUUID());
        }
        return removed;
    }

    public boolean containsCart(EntityMinecart cart) {
        if (cart == null) {
            return false;
        }
        return this.carts.contains(cart.getPersistentID());
    }

    public boolean isTrainEnd(EntityMinecart cart) {
        if (cart == null) {
            return false;
        }
        return this.getEnds().contains(cart.getPersistentID());
    }

    public Set<UUID> getEnds() {
        HashSet<UUID> ends = new HashSet<UUID>();
        ends.add(this.carts.getFirst());
        ends.add(this.carts.getLast());
        return ends;
    }

    public EntityLocomotive getLocomotive() {
        LinkageManager lm = LinkageManager.instance();
        for (UUID id : this.getEnds()) {
            EntityMinecart cart = lm.getCartFromUUID(id);
            if (!(cart instanceof EntityLocomotive)) continue;
            return (EntityLocomotive)cart;
        }
        return null;
    }

    public <T extends EntityMinecart> Collection<T> getCarts(Class<T> cartClass) {
        ArrayList list = Lists.newArrayList();
        for (EntityMinecart cart : this) {
            if (!cartClass.isInstance(cart)) continue;
            list.add((EntityMinecart)cartClass.cast(cart));
        }
        return list;
    }

    public List<UUID> getUUIDs() {
        return this.safeCarts;
    }

    public int size() {
        return this.carts.size();
    }

    public boolean isEmpty() {
        return this.carts.isEmpty();
    }

    public int getNumRunningLocomotives() {
        int count = 0;
        for (EntityMinecart cart : this) {
            if (!(cart instanceof EntityLocomotive) || !((EntityLocomotive)cart).isRunning()) continue;
            ++count;
        }
        return count;
    }

    public void refreshMaxSpeed() {
        this.setMaxSpeed(this.getMaxSpeed());
    }

    public float getMaxSpeed() {
        float speed = 1.2f;
        int numLocomotives = this.getNumRunningLocomotives();
        for (EntityMinecart c : this) {
            IElectricMinecart e;
            float baseSpeed = c.getMaxCartSpeedOnRail();
            if (numLocomotives > 0 && !(c instanceof EntityCartEnergy) && c instanceof IElectricMinecart && (e = (IElectricMinecart)c).getChargeHandler().getType() != IElectricMinecart.ChargeHandler.Type.USER) {
                baseSpeed = Math.min(0.2f, 0.03f + (float)(numLocomotives - 1) * 0.075f);
            }
            speed = Math.min(speed, baseSpeed);
        }
        return speed;
    }

    public void setMaxSpeed(float trainSpeed) {
        for (EntityMinecart c : this) {
            c.setCurrentCartSpeedCapOnRail(trainSpeed);
        }
    }

    public boolean isTrainLockedDown() {
        return !this.lockingTracks.isEmpty();
    }

    public void addLockingTrack(UUID track) {
        this.lockingTracks.add(track);
    }

    public void removeLockingTrack(UUID track) {
        this.lockingTracks.remove(track);
    }

    public boolean isIdle() {
        return this.trainState == TrainState.IDLE || this.isTrainLockedDown();
    }

    public boolean isStopped() {
        return this.trainState == TrainState.STOPPED;
    }

    public void setTrainState(TrainState state) {
        this.trainState = state;
    }

    public static enum TrainState {
        STOPPED,
        IDLE,
        NORMAL;

    }
}

