/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TankToolkit
implements IFluidHandler {
    private final IFluidHandler tankContainer;

    public TankToolkit(IFluidHandler c) {
        this.tankContainer = c;
    }

    public int getFluidQty(Fluid fluid) {
        if (fluid == null) {
            return 0;
        }
        int amount = 0;
        for (FluidTankInfo tank : this.getTankInfo(ForgeDirection.UNKNOWN)) {
            if (tank.fluid == null || fluid != tank.fluid.getFluid()) continue;
            amount += tank.fluid.amount;
        }
        return amount;
    }

    public boolean isTankEmpty(Fluid fluid) {
        if (fluid == null) {
            return this.areTanksEmpty();
        }
        return this.getFluidQty(fluid) <= 0;
    }

    public boolean isTankFull(Fluid fluid) {
        if (fluid == null) {
            return this.areTanksFull();
        }
        int fill = this.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid, 1), false);
        return fill <= 0;
    }

    public boolean areTanksFull() {
        for (FluidTankInfo tank : this.getTankInfo(ForgeDirection.UNKNOWN)) {
            if (tank.fluid != null && tank.fluid.amount >= tank.capacity) continue;
            return false;
        }
        return true;
    }

    public boolean areTanksEmpty() {
        return !this.isFluidInTank();
    }

    public boolean isFluidInTank() {
        for (FluidTankInfo tank : this.getTankInfo(ForgeDirection.UNKNOWN)) {
            boolean empty;
            boolean bl = empty = tank.fluid == null || tank.fluid.amount <= 0;
            if (empty) continue;
            return true;
        }
        return false;
    }

    public float getFluidLevel() {
        int amount = 0;
        int capacity = 0;
        for (FluidTankInfo tank : this.getTankInfo(ForgeDirection.UNKNOWN)) {
            FluidStack liquid = tank.fluid;
            amount += liquid == null ? 0 : liquid.amount;
            capacity += tank.capacity;
        }
        return capacity == 0 ? 0.0f : (float)(amount / capacity);
    }

    public float getFluidLevel(Fluid fluid) {
        int amount = 0;
        int capacity = 0;
        for (FluidTankInfo tank : this.getTankInfo(ForgeDirection.UNKNOWN)) {
            FluidStack liquid = tank.fluid;
            if (liquid == null || liquid.getFluid() != fluid) continue;
            amount += liquid.amount;
            capacity += tank.capacity;
        }
        return capacity == 0 ? 0.0f : (float)amount / (float)capacity;
    }

    public boolean canPutFluid(ForgeDirection from, FluidStack liquid) {
        if (liquid == null) {
            return false;
        }
        return this.fill(from, liquid, false) > 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankContainer.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankContainer.drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankContainer.drain(from, resource, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        return this.tankContainer.getTankInfo(side);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankContainer.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankContainer.canDrain(from, fluid);
    }
}

