/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.ISignalPacketBuilder;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiInteger;
import mods.railcraft.common.util.network.PacketGuiReturn;
import mods.railcraft.common.util.network.PacketGuiString;
import mods.railcraft.common.util.network.PacketGuiWidget;
import mods.railcraft.common.util.network.PacketKeyPress;
import mods.railcraft.common.util.network.PacketPairRequest;
import mods.railcraft.common.util.network.PacketPairUpdate;
import mods.railcraft.common.util.network.PacketTicketGui;
import mods.railcraft.common.util.network.PacketTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;

public class PacketBuilder
implements ISignalPacketBuilder {
    private static PacketBuilder instance;

    public static PacketBuilder instance() {
        if (instance == null) {
            instance = new PacketBuilder();
        }
        return instance;
    }

    private PacketBuilder() {
    }

    public void sendTileEntityPacket(RailcraftTileEntity tile) {
        if (tile.func_145831_w() instanceof WorldServer) {
            WorldServer world = (WorldServer)tile.func_145831_w();
            PacketTileEntity pkt = new PacketTileEntity(tile);
            PacketDispatcher.sendToWatchers(pkt, world, tile.field_145851_c, tile.field_145849_e);
        }
    }

    @Override
    public void sendPairPacketUpdate(AbstractPair pairing) {
        PacketPairUpdate pkt = new PacketPairUpdate(pairing);
        PacketDispatcher.sendToDimension(pkt, pairing.getTile().func_145831_w().field_73011_w.field_76574_g);
    }

    @Override
    public void sendPairPacketRequest(AbstractPair pairing) {
        PacketPairRequest pkt = new PacketPairRequest(pairing);
        PacketDispatcher.sendToServer(pkt);
    }

    public void sendGuiReturnPacket(IGuiReturnHandler handler) {
        PacketGuiReturn pkt = new PacketGuiReturn(handler);
        PacketDispatcher.sendToServer(pkt);
    }

    public void sendGuiReturnPacket(IGuiReturnHandler handler, byte[] extraData) {
        PacketGuiReturn pkt = new PacketGuiReturn(handler, extraData);
        PacketDispatcher.sendToServer(pkt);
    }

    public void sendKeyPressPacket(PacketKeyPress.EnumKeyBinding keyPress) {
        PacketKeyPress pkt = new PacketKeyPress(keyPress);
        PacketDispatcher.sendToServer(pkt);
    }

    public void sendGuiIntegerPacket(EntityPlayerMP player, int windowId, int key, int value) {
        PacketGuiInteger pkt = new PacketGuiInteger(windowId, key, value);
        PacketDispatcher.sendToPlayer(pkt, player);
    }

    public void sendGuiStringPacket(EntityPlayerMP player, int windowId, int key, String value) {
        PacketGuiString pkt = new PacketGuiString(windowId, key, value);
        PacketDispatcher.sendToPlayer(pkt, player);
    }

    public void sendGuiWidgetPacket(EntityPlayerMP player, int windowId, int widgetId, byte[] data) {
        PacketGuiWidget pkt = new PacketGuiWidget(windowId, widgetId, data);
        PacketDispatcher.sendToPlayer(pkt, player);
    }

    public void sendGoldenTicketGuiPacket(EntityPlayerMP player) {
        PacketTicketGui pkt = new PacketTicketGui();
        PacketDispatcher.sendToPlayer(pkt, player);
    }
}

