/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import java.util.HashMap;
import java.util.Map;
import makamys.coretweaks.CoreTweaks;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;

public class ClientChunkMap
extends LongHashMap {
    int radius = 32;
    int offX;
    int offZ;
    int chunksContained = 0;
    Chunk[][] map;
    Map<Long, Chunk> farMap = new HashMap<Long, Chunk>();
    LongHashMap testMap;
    boolean test = Boolean.parseBoolean(System.getProperty("owg.debugClientChunkMap", "false"));

    public ClientChunkMap() {
        this.map = new Chunk[this.radius * 2 + 1][this.radius * 2 + 1];
        if (this.test) {
            this.testMap = new LongHashMap();
        }
    }

    public void onBug() {
        CoreTweaks.LOGGER.info("Bug detected in ClientChunkMap");
    }

    public int func_76162_a() {
        int result = this.chunksContained;
        if (this.testMap != null && result != this.testMap.func_76162_a()) {
            this.onBug();
        }
        return result;
    }

    public Object func_76164_a(long xz) {
        int chunkX = (int)(xz & 0xFFFFFFFFFFFFFFFFL);
        int chunkZ = (int)(xz >> 32 & 0xFFFFFFFFFFFFFFFFL);
        Chunk result = null;
        result = this.isInRange(chunkX, chunkZ) ? this.getMapElement(chunkX, chunkZ) : this.farMap.get(xz);
        if (this.testMap != null && result != this.testMap.func_76164_a(xz)) {
            this.onBug();
        }
        return result;
    }

    private Chunk getMapElement(int x, int z) {
        int mapX = Math.floorMod(x, this.radius * 2 + 1);
        int mapZ = Math.floorMod(z, this.radius * 2 + 1);
        return this.map[mapX][mapZ];
    }

    private void putMapElement(Chunk chunk, int x, int z) {
        int mapX = Math.floorMod(x, this.radius * 2 + 1);
        int mapZ = Math.floorMod(z, this.radius * 2 + 1);
        if (this.chunkXinternal2world(mapX) != x || this.chunkZinternal2world(mapZ) != z) {
            this.onBug();
        }
        this.map[mapX][mapZ] = chunk;
    }

    private boolean isInRange(int x, int z) {
        return x >= this.offX && x < this.offX + 2 * this.radius + 1 && z >= this.offZ && z < this.offZ + 2 * this.radius + 1;
    }

    public boolean func_76161_b(long xz) {
        boolean result;
        int chunkX = (int)(xz & 0xFFFFFFFFFFFFFFFFL);
        int chunkZ = (int)(xz >> 32 & 0xFFFFFFFFFFFFFFFFL);
        boolean bl = result = this.isInRange(chunkX, chunkZ) && this.getMapElement(chunkX, chunkZ) != null || this.farMap.containsKey(xz);
        if (this.testMap != null && result != this.testMap.func_76161_b(xz)) {
            this.onBug();
        }
        return result;
    }

    public void func_76163_a(long key, Object obj) {
        if (obj instanceof Chunk) {
            Chunk chunk = (Chunk)obj;
            if (this.isInRange(chunk.field_76635_g, chunk.field_76647_h)) {
                this.putMapElement(chunk, chunk.field_76635_g, chunk.field_76647_h);
            } else {
                this.farMap.put(key, chunk);
            }
            ++this.chunksContained;
        } else {
            throw new IllegalArgumentException("tried to add non-chunk object " + obj + " to ClientChunkMap!");
        }
        if (this.testMap != null) {
            this.testMap.func_76163_a(key, obj);
        }
    }

    public Object func_76159_d(long xz) {
        Chunk result;
        int chunkX = (int)(xz & 0xFFFFFFFFFFFFFFFFL);
        int chunkZ = (int)(xz >> 32 & 0xFFFFFFFFFFFFFFFFL);
        --this.chunksContained;
        if (this.isInRange(chunkX, chunkZ)) {
            Chunk chunk = this.getMapElement(chunkX, chunkZ);
            this.putMapElement(null, chunkX, chunkZ);
            result = chunk;
        } else {
            result = this.farMap.remove(xz);
        }
        if (this.testMap != null && result != this.testMap.func_76159_d(xz)) {
            this.onBug();
        }
        return result;
    }

    private int getDiameter() {
        return this.radius * 2 + 1;
    }

    private int chunkXinternal2world(int x) {
        return (Math.floorDiv(this.offX, this.getDiameter()) + (x < Math.floorMod(this.offX, this.getDiameter()) ? 1 : 0)) * this.getDiameter() + x;
    }

    private int chunkZinternal2world(int z) {
        return (Math.floorDiv(this.offZ, this.getDiameter()) + (z < Math.floorMod(this.offZ, this.getDiameter()) ? 1 : 0)) * this.getDiameter() + z;
    }

    private void updateDirty(int x, int z) {
        Chunk farChunk;
        x = Math.floorMod(x, this.getDiameter());
        z = Math.floorMod(z, this.getDiameter());
        int worldX = this.chunkXinternal2world(x);
        int worldZ = this.chunkZinternal2world(z);
        Chunk chunk = this.getMapElement(x, z);
        if (chunk != null && !this.isInRange(chunk.field_76635_g, chunk.field_76647_h)) {
            this.farMap.put(ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), chunk);
            this.map[x][z] = null;
        }
        if ((farChunk = this.farMap.remove(ChunkCoordIntPair.func_77272_a((int)worldX, (int)worldZ))) != null) {
            this.putMapElement(farChunk, farChunk.field_76635_g, farChunk.field_76647_h);
        }
    }

    public void setCenter(int newCenterX, int newCenterZ) {
        int newX = newCenterX - this.radius;
        int newZ = newCenterZ - this.radius;
        int oldOffX = this.offX;
        int oldOffZ = this.offZ;
        if (newX == this.offX && newZ == this.offZ) {
            return;
        }
        this.offX = newX;
        this.offZ = newZ;
        int signDx = (int)Math.signum(newX - oldOffX);
        int signDz = (int)Math.signum(newZ - oldOffZ);
        for (int px = oldOffX + (signDx > 0 ? 0 : -1); px != newX + (signDx > 0 ? 0 : -1); px += signDx) {
            for (int z = 0; z < this.getDiameter(); ++z) {
                this.updateDirty(px, z);
            }
        }
        for (int pz = oldOffZ + (signDz > 0 ? 0 : -1); pz != newZ + (signDz > 0 ? 0 : -1); pz += signDz) {
            for (int x = 0; x < this.getDiameter(); ++x) {
                this.updateDirty(x, pz);
            }
        }
        if (this.test) {
            for (Chunk chunk : this.farMap.values()) {
                if (!this.isInRange(chunk.field_76635_g, chunk.field_76647_h)) continue;
                this.onBug();
            }
        }
    }
}

