/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.tweak.crashhandler;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.util.GLUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.crash.CrashReport;

public class CrashHandler {
    public static void resetState() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            LoadController modController = (LoadController)ReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"modController"});
            Multimap errors = (Multimap)ReflectionHelper.getPrivateValue(LoadController.class, (Object)modController, (String[])new String[]{"errors"});
            errors.clear();
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            GLUtil.resetState();
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            boolean isDrawing = (Boolean)ReflectionHelper.getPrivateValue(Tessellator.class, (Object)Tessellator.field_78398_a, (String[])new String[]{"isDrawing", "field_78415_z"});
            if (isDrawing) {
                Tessellator.field_78398_a.func_78381_a();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (Object)-1L, (String[])new String[]{"field_83002_am"});
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            if (Minecraft.func_71410_x().field_71438_f != null) {
                List renderersToUpdate = (List)ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)Minecraft.func_71410_x().field_71438_f, (String[])new String[]{"worldRenderersToUpdate", "field_72767_j"});
                renderersToUpdate.clear();
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException renderersToUpdate) {
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            for (Exception e : exceptions) {
                CoreTweaks.LOGGER.warn("Something went wrong while attempting to restore state after the crash (this is not related to the above crash!): " + e.getMessage());
            }
        }
    }

    public static void createCrashReport(CrashReport crashReporter) {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        CoreTweaks.LOGGER.info(crashReporter.func_71502_e());
        if (crashReporter.func_71497_f() != null) {
            CoreTweaks.LOGGER.info("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReporter.func_71497_f());
        } else if (crashReporter.func_147149_a(file2)) {
            CoreTweaks.LOGGER.info("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
        } else {
            CoreTweaks.LOGGER.info("#@?@# Game crashed! Crash report could not be saved. #@?@#");
        }
    }
}

