/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.Tuple2;
import bq_standard.core.BQ_Standard;
import bq_standard.rewards.RewardChoice;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public class NetRewardChoice {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:choice_reward");

    public static void registerHandler() {
        QuestingAPI.getAPI(ApiReference.PACKET_REG).registerServerHandler(ID_NAME, NetRewardChoice::onServer);
        if (BQ_Standard.proxy.isClient()) {
            QuestingAPI.getAPI(ApiReference.PACKET_REG).registerClientHandler(ID_NAME, NetRewardChoice::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestChoice(UUID questID, int rewardID, int index) {
        NBTTagCompound payload = NBTConverter.UuidValueType.QUEST.writeId(questID);
        payload.func_74768_a("rewardID", rewardID);
        payload.func_74768_a("selection", index);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    public static void sendChoice(@Nonnull EntityPlayerMP player, UUID questID, int rewardID, int index) {
        NBTTagCompound payload = NBTConverter.UuidValueType.QUEST.writeId(questID);
        payload.func_74768_a("rewardID", rewardID);
        payload.func_74768_a("selection", index);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        IReward reward;
        int sel;
        EntityPlayerMP sender = message.func_76340_b();
        NBTTagCompound tag = message.func_76341_a();
        Optional<UUID> qID = NBTConverter.UuidValueType.QUEST.tryReadId(tag);
        int rID = tag.func_74764_b("rewardID") ? tag.func_74762_e("rewardID") : -1;
        int n = sel = tag.func_74764_b("selection") ? tag.func_74762_e("selection") : -1;
        if (!qID.isPresent() || rID < 0) {
            return;
        }
        IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).get(qID.get());
        IReward iReward = reward = quest == null ? null : (IReward)quest.getRewards().getValue(rID);
        if (reward instanceof RewardChoice) {
            RewardChoice rChoice = (RewardChoice)reward;
            rChoice.setSelection(QuestingAPI.getQuestingUUID((EntityPlayer)sender), sel);
            NetRewardChoice.sendChoice(sender, qID.get(), rID, sel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        IReward reward;
        int sel;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Optional<UUID> qID = NBTConverter.UuidValueType.QUEST.tryReadId(message);
        int rID = message.func_150297_b("rewardID", 99) ? message.func_74762_e("rewardID") : -1;
        int n = sel = message.func_150297_b("selection", 99) ? message.func_74762_e("selection") : -1;
        if (!qID.isPresent() || rID < 0) {
            return;
        }
        IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).get(qID.get());
        IReward iReward = reward = quest == null ? null : (IReward)quest.getRewards().getValue(rID);
        if (reward instanceof RewardChoice) {
            ((RewardChoice)reward).setSelection(QuestingAPI.getQuestingUUID((EntityPlayer)player), sel);
            MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.QUEST));
        }
    }
}

